/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Streams;
import com.google.common.collect.UnmodifiableIterator;
import com.sap.cds.CdsDataStore;
import com.sap.cds.CdsException;
import com.sap.cds.DataStoreConfiguration;
import com.sap.cds.Result;
import com.sap.cds.ResultBuilder;
import com.sap.cds.SessionContext;
import com.sap.cds.impl.Cascader;
import com.sap.cds.impl.ConnectedClient;
import com.sap.cds.impl.ConnectedDataStoreConnector;
import com.sap.cds.impl.Context;
import com.sap.cds.impl.CqnValidator;
import com.sap.cds.impl.EntityCascader;
import com.sap.cds.impl.PreparedCqnStatement;
import com.sap.cds.impl.TimingLogger;
import com.sap.cds.impl.builder.model.Conjunction;
import com.sap.cds.impl.builder.model.CqnParam;
import com.sap.cds.impl.docstore.DocStoreUtils;
import com.sap.cds.impl.parser.token.CqnBoolLiteral;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Delete;
import com.sap.cds.ql.Insert;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.Update;
import com.sap.cds.ql.Upsert;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnAnalyzer;
import com.sap.cds.ql.cqn.CqnDelete;
import com.sap.cds.ql.cqn.CqnInsert;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnUpdate;
import com.sap.cds.ql.cqn.CqnUpsert;
import com.sap.cds.ql.cqn.CqnXsert;
import com.sap.cds.ql.impl.CqnNormalizer;
import com.sap.cds.ql.impl.DeepInsertSplitter;
import com.sap.cds.ql.impl.DeepUpdateSplitter;
import com.sap.cds.ql.impl.DeleteBuilder;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.CqnStatementUtils;
import com.sap.cds.util.DataUtils;
import com.sap.cds.util.PathExpressionResolver;
import com.sap.cds.util.ProjectionProcessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdsDataStoreImpl
implements CdsDataStore {
    private final CqnValidator cqnValidator;
    private final ConnectedClient connectedClient;
    private final CqnNormalizer cqnNormalizer;
    private final CqnAnalyzer cqnAnalyzer;
    private final DataUtils dataUtils;
    private final Context context;
    private final CdsModel model;
    private final ProjectionProcessor projectionProcessor;
    private static final Logger logger = LoggerFactory.getLogger(CdsDataStoreImpl.class);
    private static final TimingLogger timed = new TimingLogger(logger);

    public CdsDataStoreImpl(Context context, ConnectedDataStoreConnector connector) {
        this.context = context;
        this.model = context.getCdsModel();
        this.cqnValidator = CqnValidator.create(context);
        this.connectedClient = connector.create(context);
        this.dataUtils = DataUtils.create(context::getSessionContext, (int)context.getDbContext().getCapabilities().timestampPrecision());
        this.connectedClient.setSessionContext(context.getSessionContext());
        this.cqnNormalizer = new CqnNormalizer(context);
        this.cqnAnalyzer = CqnAnalyzer.create((CdsModel)this.model);
        this.projectionProcessor = ProjectionProcessor.create((CdsModel)this.model, (CqnAnalyzer)this.cqnAnalyzer, (DataUtils)this.dataUtils);
    }

    public Result execute(CqnSelect select, Object ... paramValues) {
        return this.execute(select, CdsDataStoreImpl.toIndexMap(paramValues));
    }

    public Result execute(CqnSelect select, Map<String, Object> cqnParameterValues) {
        return (Result)timed.debug(() -> {
            CdsEntity targetEntity = null;
            CdsEntity rowType = null;
            if (select.from().isRef()) {
                targetEntity = CdsModelUtils.entity((CdsModel)this.model, (CqnStructuredTypeRef)select.from().asRef());
                if (CqnStatementUtils.isSelectStar((List)select.items()) && select.excluding().isEmpty()) {
                    rowType = targetEntity;
                }
            }
            CqnSelect normSelect = this.cqnNormalizer.normalize(select);
            this.cqnValidator.validate(normSelect, this.connectedClient.capabilities());
            if (rowType == null) {
                rowType = CqnStatementUtils.rowType((CdsModel)this.model, (CqnSelect)normSelect);
            }
            normSelect = this.cqnNormalizer.resolveForwardMappedAssocs(normSelect);
            PreparedCqnStatement pcqn = this.connectedClient.prepare((CqnStatement)normSelect);
            ResultBuilder result = this.connectedClient.executeQuery(pcqn, cqnParameterValues, this, normSelect.getLock().isPresent()).rowType((CdsStructuredType)rowType);
            if (normSelect.hasInlineCount()) {
                long rowCount = result.result().rowCount();
                if (normSelect.hasLimit() && CdsDataStoreImpl.requiresInlineCountQuery(normSelect.top(), normSelect.skip(), rowCount)) {
                    result.inlineCount(this.getInlineCount(normSelect, cqnParameterValues));
                } else {
                    result.inlineCount(rowCount);
                }
            }
            return result.entity(targetEntity).result();
        }, "CQN >>{}<<", () -> new Object[]{CdsDataStoreImpl.safeToJson((CqnStatement)select, this.context.getDataStoreConfiguration())});
    }

    public Result execute(CqnSelect select, Iterable<Map<String, Object>> valueSets, int maxBatchSize) {
        int valueSetSize = Iterables.size(valueSets);
        if (valueSetSize == 1) {
            return this.execute(select, valueSets.iterator().next());
        }
        if (!select.orderBy().isEmpty() && valueSetSize > maxBatchSize) {
            throw new UnsupportedOperationException("Order by is not supported when query is executed in multiple batches");
        }
        ArrayList rows = new ArrayList(valueSetSize);
        UnmodifiableIterator partitions = Iterators.partition(valueSets.iterator(), (int)maxBatchSize);
        while (partitions.hasNext()) {
            CqnSelect batchSelect = CqnStatementUtils.batchSelect((CqnSelect)select, (List)((List)partitions.next()));
            List result = this.execute(batchSelect, new Object[0]).list();
            rows.addAll(result);
        }
        return ResultBuilder.selectedRows(rows).result();
    }

    private long getInlineCount(CqnSelect select, Map<String, Object> cqnParameterValues) {
        CqnSelect inlineCountQuery = CqnStatementUtils.inlineCountQuery((CqnSelect)select);
        PreparedCqnStatement pcqn = this.connectedClient.prepare((CqnStatement)inlineCountQuery);
        Result result = this.connectedClient.executeQuery(pcqn, cqnParameterValues, this, false).result();
        return ((CqnStatementUtils.Count)result.single(CqnStatementUtils.Count.class)).getCount();
    }

    @VisibleForTesting
    static String safeToJson(CqnStatement statement, DataStoreConfiguration config) {
        boolean doLogValues = config.getProperty("cds.ql.logging.log-values", false);
        try {
            if (!doLogValues) {
                return CqnStatementUtils.anonymizeStatement((CqnStatement)statement).toJson();
            }
            return statement.toJson();
        }
        catch (RuntimeException ex) {
            logger.error("cannot serialize CQN statement");
            return "Unserializable CQN";
        }
    }

    @VisibleForTesting
    static boolean requiresInlineCountQuery(long top, long skip, long rowCount) {
        return skip > 0L || top <= rowCount;
    }

    public Result execute(CqnDelete delete, Object ... paramValues) {
        return this.execute(delete, CdsDataStoreImpl.toIndexMap(paramValues));
    }

    public Result execute(CqnDelete delete, Map<String, Object> namedValues) {
        return this.execute(delete, Collections.singletonList(namedValues));
    }

    public Result execute(CqnDelete delete, Iterable<Map<String, Object>> valueSets) {
        delete = (CqnDelete)this.projectionProcessor.resolve((CqnStatement)delete);
        CdsEntity target = CdsModelUtils.entity((CdsModel)this.model, (CqnStructuredTypeRef)(delete = this.cqnNormalizer.normalize(delete)).ref());
        boolean deleted = Cascader.create(CdsModelUtils.CascadeType.DELETE, target).from(delete.ref()).where(delete.where()).cascade(path -> this.bulkDelete((CqnDelete)Delete.from((StructuredType)path), valueSets, true));
        if (deleted) {
            return this.bulkDelete(delete, valueSets, false);
        }
        target = this.model.getEntity(delete.ref().firstSegment());
        Set<EntityCascader.EntityKeys> entities = this.cascade(target, delete.where(), valueSets);
        Result result = this.bulkDelete(delete, valueSets, false);
        this.delete(entities.stream().map(k -> EntityCascader.EntityOperation.delete(k, null, this.context.getSessionContext())), true);
        return result;
    }

    private Set<EntityCascader.EntityKeys> cascade(CdsEntity target, Optional<CqnPredicate> filter, Iterable<? extends Map<String, Object>> valueSets) {
        EntityCascader cascader = EntityCascader.from(this, target).where(filter);
        Set<EntityCascader.EntityKeys> keySets = valueSets.iterator().hasNext() ? Streams.stream(valueSets).flatMap(v -> cascader.with((Map<String, Object>)v).cascade(CdsModelUtils.CascadeType.DELETE).stream()).collect(Collectors.toSet()) : cascader.cascade(CdsModelUtils.CascadeType.DELETE);
        return keySets;
    }

    private void updateOrInsert(Stream<EntityCascader.EntityOperation> operations) {
        List<EntityCascader.EntityOperation> notInDatastore = this.update(operations);
        this.insert(notInDatastore.stream());
    }

    private void insert(Stream<EntityCascader.EntityOperation> ops) {
        ops.collect(Collectors.groupingBy(EntityCascader.EntityOperation::targetEntity)).forEach((entity, data) -> {
            Iterator rows = this.execute((CqnInsert)Insert.into((CdsEntity)entity).entries((Iterable)data)).iterator();
            for (EntityCascader.EntityOperation op : data) {
                op.inserted((Map)rows.next());
            }
        });
    }

    private void groupAndExecute(Stream<EntityCascader.EntityOperation> ops, BiConsumer<CdsEntity, List<EntityCascader.EntityOperation>> action) {
        ops.collect(Collectors.groupingBy(o -> Objects.hash(o.targetEntity().getQualifiedName(), o.updateValues().keySet()))).forEach((g, batch) -> {
            CdsEntity entity = ((EntityCascader.EntityOperation)((Object)((Object)batch.get(0)))).targetEntity();
            action.accept(entity, (List<EntityCascader.EntityOperation>)batch);
        });
    }

    private void upsert(Stream<EntityCascader.EntityOperation> ops) {
        this.groupAndExecute(ops, (entity, upserts) -> {
            List entries = upserts.stream().map(EntityCascader.EntityOperation::updateValues).collect(Collectors.toList());
            Result result = this.execute((CqnUpsert)Upsert.into((CdsEntity)entity).entries(entries));
            Iterator resultIter = result.iterator();
            Iterator upsertIter = upserts.iterator();
            for (int i = 0; i < result.batchCount(); ++i) {
                EntityCascader.EntityOperation u = (EntityCascader.EntityOperation)((Object)((Object)upsertIter.next()));
                u.inserted((Map)resultIter.next());
            }
        });
    }

    private List<EntityCascader.EntityOperation> update(Stream<EntityCascader.EntityOperation> ops) {
        ArrayList<EntityCascader.EntityOperation> notFound = new ArrayList<EntityCascader.EntityOperation>();
        this.groupAndExecute(ops, (entity, updates) -> {
            List entries = updates.stream().map(EntityCascader.EntityOperation::updateValues).collect(Collectors.toList());
            Result result = this.execute((CqnUpdate)Update.entity((CdsEntity)entity).entries(entries));
            if (result.rowCount() > 0L) {
                Iterator resultIter = result.iterator();
                Iterator updateIter = updates.iterator();
                for (int i = 0; i < result.batchCount(); ++i) {
                    EntityCascader.EntityOperation u = (EntityCascader.EntityOperation)((Object)((Object)updateIter.next()));
                    long rowCount = result.rowCount(i);
                    u.updated((Map)resultIter.next(), rowCount);
                    if (rowCount != 0L) continue;
                    notFound.add(u);
                }
            } else {
                notFound.addAll((Collection<EntityCascader.EntityOperation>)updates);
            }
        });
        return notFound;
    }

    private void delete(Stream<EntityCascader.EntityOperation> ops, boolean rollbackOnFail) {
        Collection<List<EntityCascader.EntityOperation>> grouped = CdsDataStoreImpl.groupByEntityAndPath(ops);
        for (List<EntityCascader.EntityOperation> batch : grouped) {
            if (batch.isEmpty()) continue;
            EntityCascader.EntityOperation o = batch.iterator().next();
            Set keyNames = o.targetKeys().keySet();
            StructuredType ref = CQL.entity((String)o.targetEntity().getQualifiedName()).matching(CqnParam.params((Collection)keyNames));
            if (o.path() != null) {
                ref = ref.to(o.path());
            }
            DeleteBuilder delete = DeleteBuilder.from((StructuredType)ref);
            this.bulkDelete((CqnDelete)delete, batch, rollbackOnFail);
            batch.forEach(EntityCascader.EntityOperation::deleted);
        }
    }

    private static Collection<List<EntityCascader.EntityOperation>> groupByEntityAndPath(Stream<EntityCascader.EntityOperation> ops) {
        ToLongFunction<String> pathLength = s -> s.chars().filter(c -> c == 46).count();
        Comparator<String> longestPath = Comparator.comparingLong(pathLength).reversed().thenComparing(Function.identity());
        TreeMap grouped = ops.collect(Collectors.groupingBy(o -> o.targetEntity().getQualifiedName() + (o.path() != null ? ":." + o.path() : ""), () -> new TreeMap(longestPath), Collectors.toList()));
        return grouped.values();
    }

    private Result bulkDelete(CqnDelete delete, Iterable<? extends Map<String, Object>> valueSets, boolean rollbackOnFail) {
        this.cqnValidator.validate(delete);
        delete = PathExpressionResolver.resolvePath((CdsModel)this.model, (CqnDelete)delete);
        CqnDelete projectedDelete = (CqnDelete)this.projectionProcessor.resolve((CqnStatement)delete);
        return (Result)timed.debug(() -> {
            PreparedCqnStatement pcqn = this.connectedClient.prepare((CqnStatement)projectedDelete);
            ArrayList<Map<String, Object>> parameterValues = new ArrayList<Map<String, Object>>();
            valueSets.forEach(parameterValues::add);
            try {
                int[] deleteCount = this.connectedClient.executeUpdate(pcqn, parameterValues);
                return ResultBuilder.deletedRows((int[])deleteCount).result();
            }
            catch (Exception e) {
                if (rollbackOnFail) {
                    this.connectedClient.setRollbackOnly();
                }
                throw e;
            }
        }, "CQN bulk delete >>{}<< with {} value sets.", new Object[]{CdsDataStoreImpl.safeToJson((CqnStatement)projectedDelete, this.context.getDataStoreConfiguration()), valueSets.spliterator().estimateSize()});
    }

    public Result execute(CqnInsert insert) {
        insert = this.isDraftEnabled(insert);
        insert = this.cqnNormalizer.normalize(insert);
        return this.deepInsert((CqnXsert)insert, false);
    }

    private CqnInsert isDraftEnabled(CqnInsert insert) {
        CdsEntity entity = this.model.getEntity(insert.ref().firstSegment());
        if (entity.findAnnotation("odata.draft.enabled").isPresent()) {
            insert = (CqnInsert)this.projectionProcessor.resolve((CqnStatement)insert);
        }
        return insert;
    }

    public Result execute(CqnUpsert upsert) {
        if (upsert.entries().isEmpty()) {
            return ResultBuilder.insertedRows(Collections.emptyList()).result();
        }
        upsert = this.cqnNormalizer.normalize(upsert);
        CdsEntity entity = CdsModelUtils.entity((CdsModel)this.model, (CqnStructuredTypeRef)upsert.ref());
        String strategy = this.context.getDataStoreConfiguration().getProperty("cds.sql.upsert.strategy", "upsert");
        strategy = upsert.hints().getOrDefault("cds.sql.upsert.strategy", strategy);
        if ("replace".equals(strategy)) {
            return this.executeReplace(upsert, entity);
        }
        this.cqnValidator.validate(upsert);
        if (DataUtils.isDeep((CdsStructuredType)entity, (Collection)upsert.entries()) || !DataUtils.uniformData((CdsStructuredType)entity, (Collection)upsert.entries())) {
            return this.deepUpsert(entity, upsert);
        }
        List entries = upsert.entries();
        this.dataUtils.prepareForUpdate((CdsStructuredType)entity, entries);
        CqnUpsert resolvedUpsert = (CqnUpsert)this.projectionProcessor.resolve((CqnStatement)upsert);
        return (Result)timed.debug(() -> {
            CdsEntity resolvedEntity = CdsModelUtils.entity((CdsModel)this.model, (CqnStructuredTypeRef)resolvedUpsert.ref());
            if (DataUtils.isDeep((CdsStructuredType)resolvedEntity, (Collection)resolvedUpsert.entries())) {
                return this.deepUpsert(entity, resolvedUpsert);
            }
            PreparedCqnStatement pcqn = this.connectedClient.prepare((CqnStatement)resolvedUpsert);
            this.connectedClient.executeUpdate(pcqn, resolvedUpsert.entries());
            return ResultBuilder.insertedRows((List)entries).result();
        }, "CQN upsert >>{}<< with {} entries.", new Object[]{CdsDataStoreImpl.safeToJson((CqnStatement)resolvedUpsert, this.context.getDataStoreConfiguration()), entries.size()});
    }

    private Result deepUpsert(CdsEntity entity, CqnUpsert upsert) {
        Map targetKeys = this.cqnAnalyzer.analyze(upsert.ref()).targetKeyValues();
        DeepUpdateSplitter updateSplitter = new DeepUpdateSplitter(this);
        EntityCascader.EntityOperations operations = updateSplitter.computeOperations(entity, upsert, (Map<String, Object>)targetKeys);
        return this.runOperations(operations).result();
    }

    private Result executeReplace(CqnUpsert upsert, CdsEntity entity) {
        this.deleteByKeys(entity, upsert.entries());
        return this.deepInsert((CqnXsert)upsert, true);
    }

    private void deleteByKeys(CdsEntity entity, Iterable<Map<String, Object>> keyValues) {
        Delete delete = Delete.from((CdsEntity)entity).matching(CdsModelUtils.keyNames((CdsStructuredType)entity).stream().collect(Collectors.toMap(k -> k, CQL::param)));
        DataUtils.normalizedUuidKeys((CdsStructuredType)entity, keyValues);
        this.execute((CqnDelete)delete, keyValues);
    }

    private Result deepInsert(CqnXsert xsert, boolean rollbackOnFail) {
        CdsEntity entity = this.model.getEntity(xsert.ref().firstSegment());
        List entries = xsert.entries();
        this.dataUtils.prepareForInsert((CdsStructuredType)entity, entries);
        List<Insert> inserts = new DeepInsertSplitter(entity, this.context.getSessionContext()).split(entries);
        boolean isRollbackOnly = rollbackOnFail || inserts.size() > 1;
        inserts.forEach(insert -> {
            this.cqnValidator.validate((CqnInsert)insert);
            CqnInsert projectedInsert = (CqnInsert)this.projectionProcessor.resolve((CqnStatement)insert);
            CdsEntity target = this.model.getEntity(projectedInsert.ref().firstSegment());
            DataUtils.resolvePaths((CdsEntity)target, (List)projectedInsert.entries());
            if (DataUtils.isDeep((CdsStructuredType)target, (Collection)projectedInsert.entries())) {
                this.deepInsert((CqnXsert)projectedInsert, true);
                return;
            }
            this.dataUtils.processOnInsert((CdsStructuredType)target, (Iterable)projectedInsert.entries());
            timed.debug(() -> {
                PreparedCqnStatement pcqn = this.connectedClient.prepare((CqnStatement)projectedInsert);
                try {
                    return this.connectedClient.executeUpdate(pcqn, projectedInsert.entries());
                }
                catch (Exception e) {
                    if (isRollbackOnly) {
                        this.connectedClient.setRollbackOnly();
                    }
                    throw e;
                }
            }, "CQN upsert >>{}<< with {} entries.", new Object[]{CdsDataStoreImpl.safeToJson((CqnStatement)projectedInsert, this.context.getDataStoreConfiguration()), projectedInsert.entries().size()});
        });
        return ResultBuilder.insertedRows((List)entries).entity(entity).result();
    }

    public Result execute(CqnUpdate update, Object ... paramValues) {
        return this.execute(update, CdsDataStoreImpl.toIndexMap(paramValues));
    }

    public Result execute(CqnUpdate update, Map<String, Object> namedValues) {
        return this.execute(update, namedValues.isEmpty() ? Collections.emptyList() : Collections.singletonList(namedValues));
    }

    public Result execute(CqnUpdate update, Iterable<Map<String, Object>> valueSets) {
        this.cqnValidator.validate(update);
        CdsEntity entity = this.cqnAnalyzer.analyze(update.ref()).targetEntity();
        this.dataUtils.prepareForUpdate((CdsStructuredType)entity, update.entries());
        if (!DataUtils.hasNonKeyValues((CdsStructuredType)entity, (Map)update.data())) {
            Result count = this.selectCountAll(update, entity, update);
            update.entries().forEach(Map::clear);
            return count;
        }
        CqnUpdate normUpdate = this.cqnNormalizer.normalize(update);
        if (DataUtils.isDeep((CdsStructuredType)entity, (Collection)normUpdate.entries()) || !DataUtils.uniformData((CdsStructuredType)entity, (Collection)normUpdate.entries())) {
            Map targetKeys = this.cqnAnalyzer.analyze(update).targetKeyValues();
            return this.deepUpdate(entity, normUpdate, targetKeys).entity(entity).result();
        }
        CqnUpdate resolvedUpdate = (CqnUpdate)this.projectionProcessor.resolve((CqnStatement)normUpdate);
        CdsEntity resolvedEntity = entity;
        if (resolvedUpdate != normUpdate) {
            resolvedEntity = this.cqnAnalyzer.analyze(resolvedUpdate.ref()).targetEntity();
            this.dataUtils.prepareForUpdate((CdsStructuredType)resolvedEntity, resolvedUpdate.entries());
            if (DataUtils.isDeep((CdsStructuredType)resolvedEntity, (Collection)resolvedUpdate.entries())) {
                Map targetKeys = this.cqnAnalyzer.analyze(update).targetKeyValues();
                return this.deepUpdate(resolvedEntity, resolvedUpdate, targetKeys).entity(entity).result();
            }
        }
        int[] updateCount = this.flatUpdate(resolvedUpdate, resolvedEntity, valueSets);
        List<Map<String, Object>> entries = update.entries();
        if (entries.size() == 1) {
            entries = CdsDataStoreImpl.filledList(updateCount.length, (Map)entries.get(0));
        }
        this.addKeyValuesToEntries(update, entries);
        return CdsDataStoreImpl.batchUpdateResult((List<? extends Map<String, Object>>)entries, updateCount).entity(entity).result();
    }

    private void addKeyValuesToEntries(CqnUpdate update, List<Map<String, Object>> entries) {
        Map keyValues = this.cqnAnalyzer.analyze(update).targetKeyValues();
        if (!keyValues.isEmpty()) {
            entries.forEach(e -> e.putAll(keyValues));
        }
    }

    private static List<Map<String, Object>> filledList(int length, Map<String, Object> entry) {
        ArrayList<Map<String, Object>> entries = new ArrayList<Map<String, Object>>(length);
        for (int i = 0; i < length; ++i) {
            entries.add(entry);
        }
        return entries;
    }

    private static ResultBuilder batchUpdateResult(List<? extends Map<String, Object>> entries, int[] updateCount) {
        return CdsDataStoreImpl.batchUpdateResult(entries, Arrays.stream(updateCount).asLongStream().toArray());
    }

    private static ResultBuilder batchUpdateResult(List<? extends Map<String, Object>> entries, long[] updateCount) {
        int size = entries.size();
        int length = updateCount.length;
        ResultBuilder builder = ResultBuilder.batchUpdate();
        for (int i = 0; i < length; ++i) {
            builder.addUpdatedRows(updateCount[i], entries.get(Math.min(size, i)));
        }
        return builder;
    }

    private int[] flatUpdate(CqnUpdate update, CdsEntity entity, Iterable<Map<String, Object>> valueSets) {
        List<Map<String, Object>> parameterValues = CdsDataStoreImpl.mergeParams(update.entries(), valueSets);
        if (!DocStoreUtils.targetsDocStore((CdsStructuredType)entity)) {
            CqnStatementUtils.moveKeyValuesToWhere((CdsStructuredType)entity, (CqnUpdate)update, (boolean)true);
        }
        return (int[])timed.debug(() -> {
            PreparedCqnStatement pcqn = this.connectedClient.prepare((CqnStatement)update);
            return this.connectedClient.executeUpdate(pcqn, parameterValues);
        }, "CQN Update >>{}<< with {} entries.", new Object[]{CdsDataStoreImpl.safeToJson((CqnStatement)update, this.context.getDataStoreConfiguration()), update.entries().size()});
    }

    private ResultBuilder deepUpdate(CdsEntity entity, CqnUpdate update, Map<String, Object> targetKeys) {
        DeepUpdateSplitter updateSplitter = new DeepUpdateSplitter(this);
        EntityCascader.EntityOperations operations = updateSplitter.computeOperations(entity, update, targetKeys);
        return this.runOperations(operations);
    }

    private ResultBuilder runOperations(EntityCascader.EntityOperations operations) {
        try {
            this.delete(operations.filter(EntityCascader.EntityOperation.Operation.DELETE), false);
            this.insert(operations.filter(EntityCascader.EntityOperation.Operation.INSERT));
            this.updateOrInsert(operations.filter(EntityCascader.EntityOperation.Operation.UPDATE_OR_INSERT));
            this.upsert(operations.filter(EntityCascader.EntityOperation.Operation.UPSERT));
            this.update(operations.filter(EntityCascader.EntityOperation.Operation.UPDATE));
        }
        catch (Exception e) {
            this.connectedClient.setRollbackOnly();
            throw e;
        }
        if (operations.entries().size() == 1 && operations.updateCount().length > 1) {
            return this.searchedUpdateResult(operations);
        }
        return CdsDataStoreImpl.batchUpdateResult(operations.entries(), operations.updateCount());
    }

    private ResultBuilder searchedUpdateResult(EntityCascader.EntityOperations operations) {
        Map<String, Object> data = operations.entries().get(0);
        return ResultBuilder.updatedRows((long)Arrays.stream(operations.updateCount()).sum(), data);
    }

    private Result selectCountAll(CqnUpdate update, CdsEntity entity, CqnUpdate resolvedUpdate) {
        Set keys = CdsModelUtils.keyNames((CdsStructuredType)entity);
        Select countQuery = CqnStatementUtils.countAll((CqnStatement)update);
        long[] rowCount = new long[resolvedUpdate.entries().size()];
        int i = 0;
        for (Map entry : update.entries()) {
            CqnPredicate where = (CqnPredicate)update.where().orElse(CqnBoolLiteral.TRUE);
            where = Conjunction.and((CqnPredicate)where, (CqnPredicate)((CqnPredicate)update.elements().filter(keys::contains).map(key -> CQL.get((String)key).eq((Value)CQL.param((String)key))).collect(Conjunction.and())));
            countQuery.where(where);
            rowCount[i] = ((CqnStatementUtils.Count)this.execute((CqnSelect)countQuery, (Map<String, Object>)entry).single().as(CqnStatementUtils.Count.class)).getCount();
            ++i;
        }
        return CdsDataStoreImpl.batchUpdateResult(CdsDataStoreImpl.filledList(rowCount.length, new HashMap<String, Object>()), rowCount).result();
    }

    private static List<Map<String, Object>> mergeParams(List<Map<String, Object>> updateData, Iterable<Map<String, Object>> valueSets) {
        ArrayList<Map<String, Object>> paramVals = new ArrayList<Map<String, Object>>();
        if (!valueSets.iterator().hasNext()) {
            updateData.forEach(v -> paramVals.add(DataUtils.copyMap((Map)v)));
            return paramVals;
        }
        valueSets.forEach(v -> paramVals.add(DataUtils.copyMap((Map)v)));
        if (updateData.size() == 1) {
            Map<String, Object> data = updateData.get(0);
            paramVals.forEach(p -> p.putAll(data));
            return paramVals;
        }
        if (updateData.size() == paramVals.size()) {
            Iterator<Map<String, Object>> keyIter = updateData.iterator();
            paramVals.forEach(p -> p.putAll((Map)keyIter.next()));
            return paramVals;
        }
        throw new CdsException("Batch update failed: Parameter value list size (" + paramVals.size() + ") does not match batch size (" + updateData.size() + ")");
    }

    private static Map<String, Object> toIndexMap(Object ... paramValues) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (int i = 0; i < paramValues.length; ++i) {
            parameters.put(String.valueOf(i), paramValues[i]);
        }
        return parameters;
    }

    public SessionContext getSessionContext() {
        return this.context.getSessionContext();
    }

    public void setSessionContext(SessionContext session) {
        this.context.setSessionContext(session);
        this.connectedClient.setSessionContext(session);
    }

    public void deleteAll(Stream<CdsEntity> entities) {
        this.connectedClient.deleteAll(entities);
    }
}

