/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.qat;

import com.sap.cds.impl.Context;
import com.sap.cds.impl.DraftUtils;
import com.sap.cds.impl.PreparedCqnStmt;
import com.sap.cds.impl.docstore.DocStoreUtils;
import com.sap.cds.impl.qat.QatAssociation;
import com.sap.cds.impl.qat.QatAssociationNode;
import com.sap.cds.impl.qat.QatElementNode;
import com.sap.cds.impl.qat.QatEntityNode;
import com.sap.cds.impl.qat.QatEntityRootNode;
import com.sap.cds.impl.qat.QatNode;
import com.sap.cds.impl.qat.QatSelectRootNode;
import com.sap.cds.impl.qat.QatSelectableNode;
import com.sap.cds.impl.qat.QatTraverser;
import com.sap.cds.impl.qat.QatVisitor;
import com.sap.cds.impl.sql.SQLHelper;
import com.sap.cds.impl.sql.SQLStatementBuilder;
import com.sap.cds.impl.sql.SelectStatementBuilder;
import com.sap.cds.impl.sql.TokenToSQLTransformer;
import com.sap.cds.jdbc.spi.SqlMapping;
import com.sap.cds.jdbc.spi.TableNameResolver;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnVisitor;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsSimpleType;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.util.CdsModelUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FromClauseBuilder {
    private static final String $JSON_ALIAS = "\"$json\"";
    private static final String INNER = "INNER";
    private static final String LEFT = "LEFT";
    private static final String OUTER = "OUTER";
    private static final String JOIN = "JOIN";
    private static final String ON = "ON";
    private static final String LPAREN = "(";
    private static final String RPAREN = ")";
    private static final String AND = "and";
    private final Context context;
    private final List<PreparedCqnStmt.Parameter> params;
    private final Map<String, Object> hints;

    public FromClauseBuilder(Context context, List<PreparedCqnStmt.Parameter> params) {
        this(context, params, Collections.emptyMap());
    }

    public FromClauseBuilder(Context context, List<PreparedCqnStmt.Parameter> params, Map<String, Object> hints) {
        this.context = context;
        this.params = params;
        this.hints = hints;
    }

    public Stream<String> with(Deque<QatSelectableNode> outer) {
        List<CTE> ctes = this.collectCTEs(outer);
        if (ctes.isEmpty()) {
            return Stream.empty();
        }
        return Stream.of("WITH", this.renderCTEs(ctes));
    }

    public Stream<String> sql(Deque<QatSelectableNode> outer) {
        ToSQLVisitor v = new ToSQLVisitor(outer);
        QatTraverser.take(v).traverse(outer.getLast());
        return v.sql();
    }

    private String renderCTEs(List<CTE> ctes) {
        return ctes.stream().map(this::renderCTE).collect(Collectors.joining(", "));
    }

    private String renderCTE(CTE cte) {
        return cte.getElements().stream().map(element -> this.mapElement((String)element, cte)).collect(Collectors.joining(", ", cte.getAlias() + " as (SELECT ", " FROM " + cte.getTableName() + RPAREN));
    }

    private String mapElement(String element, CTE cte) {
        if ("$json".equals(element)) {
            return cte.tableName + " as " + $JSON_ALIAS;
        }
        return SQLHelper.delimited((String)this.context.getDbContext().casing().apply(element));
    }

    private List<CTE> collectCTEs(Deque<QatSelectableNode> outer) {
        final ArrayList<CTE> collectedCTEs = new ArrayList<CTE>();
        QatVisitor cteVisitor = new QatVisitor(){

            @Override
            public void visit(QatAssociationNode assoc) {
                CdsEntity targetEntity = assoc.association().targetEntity();
                if (DocStoreUtils.targetsDocStore((CdsStructuredType)targetEntity)) {
                    SqlMapping sqlMapping = FromClauseBuilder.this.getSqlMapping(targetEntity);
                    HashSet<String> elements = new HashSet<String>();
                    assoc.children().stream().map(QatNode::name).forEach(elements::add);
                    targetEntity.keyElements().map(CdsElement::getName).forEach(elements::add);
                    collectedCTEs.add(new CTE(sqlMapping.tableName(), assoc.alias(), elements));
                }
            }
        };
        QatTraverser.take(cteVisitor).traverse(outer.getLast());
        return collectedCTEs;
    }

    private SqlMapping getSqlMapping(CdsEntity targetEntity) {
        return this.context.getDbContext().getSqlMapping((CdsStructuredType)targetEntity);
    }

    private static EnumSet<DraftUtils.Element> draftElements(QatEntityNode node) {
        final EnumSet<DraftUtils.Element> draftElements = EnumSet.noneOf(DraftUtils.Element.class);
        for (QatNode child : node.children()) {
            child.accept(new QatVisitor(){

                @Override
                public void visit(QatElementNode elementNode) {
                    DraftUtils.draftElement(elementNode.element()).ifPresent(draftElements::add);
                }

                @Override
                public void visit(QatAssociationNode association) {
                    QatAssociation assoc = association.association();
                    if (assoc.on() != null) {
                        assoc.on().accept(new CqnVisitor(){

                            public void visit(CqnElementRef ref) {
                                if (ref.size() == 1) {
                                    DraftUtils.draftElement(ref.lastSegment()).ifPresent(draftElements::add);
                                }
                            }
                        });
                    }
                }
            });
        }
        return draftElements;
    }

    private static void checkRef(CqnElementRef ref) {
        if (CdsModelUtils.isContextElementRef((CqnElementRef)ref)) {
            throw new IllegalStateException("Can't convert context element ref to column name");
        }
    }

    private class PlainTableNameResolver
    implements TableNameResolver {
        private PlainTableNameResolver() {
        }

        public String tableName(CdsEntity entity) {
            return FromClauseBuilder.this.getSqlMapping(entity).tableName();
        }
    }

    private static final class CTE {
        private final String alias;
        private final Set<String> elements;
        private final String tableName;

        public CTE(String tableName, String alias, Set<String> elements) {
            this.tableName = tableName;
            this.elements = elements;
            this.alias = alias;
        }

        public String getAlias() {
            return this.alias;
        }

        public Set<String> getElements() {
            return this.elements;
        }

        public String getTableName() {
            return this.tableName;
        }
    }

    private class ToSQLVisitor
    implements QatVisitor {
        final Deque<QatSelectableNode> outer;
        final Stream.Builder<String> sql = Stream.builder();

        public ToSQLVisitor(Deque<QatSelectableNode> outer) {
            this.outer = outer;
        }

        @Override
        public void visit(QatEntityRootNode root) {
            this.assertFilterHasNoPaths(root);
            this.table(root);
        }

        @Override
        public void visit(QatSelectRootNode root) {
            this.subSelect(root.select(), root.alias());
        }

        @Override
        public void visit(QatAssociationNode assoc) {
            this.assertFilterHasNoPaths(assoc);
            if (assoc.inSource()) {
                this.add(FromClauseBuilder.INNER);
            } else {
                this.add(FromClauseBuilder.LEFT);
                this.add(FromClauseBuilder.OUTER);
            }
            this.add(FromClauseBuilder.JOIN);
            this.table(assoc);
            this.add(FromClauseBuilder.ON);
            if (assoc.inSource()) {
                this.onConditionFilterOnParent(assoc);
            } else {
                this.onConditionFilterOnTarget(assoc);
            }
        }

        private void assertFilterHasNoPaths(QatEntityNode node) {
            node.filter().ifPresent(f -> f.accept(new CqnVisitor(){

                public void visit(CqnElementRef ref) {
                    if (ref.size() > 1) {
                        throw new UnsupportedOperationException("Path " + ref + " in infix filter is not supported");
                    }
                }
            }));
        }

        private void onConditionFilterOnParent(QatAssociationNode assoc) {
            this.onCondition(assoc, (QatEntityNode)assoc.parent());
        }

        private void onConditionFilterOnTarget(QatAssociationNode assoc) {
            this.onCondition(assoc, assoc);
        }

        private void onCondition(QatAssociationNode assoc, QatEntityNode filtered) {
            CqnPredicate on = assoc.association().on();
            TokenToSQLTransformer onToSQL = TokenToSQLTransformer.notCollating(FromClauseBuilder.this.context, FromClauseBuilder.this.params, this.refInOnToAlias(assoc), this.outer);
            Optional<CqnPredicate> filter = filtered.filter();
            if (filter.isPresent()) {
                this.add(FromClauseBuilder.LPAREN);
                this.add(onToSQL.toSQL(on));
                this.add(FromClauseBuilder.RPAREN);
                TokenToSQLTransformer filterToSQL = TokenToSQLTransformer.notCollating(FromClauseBuilder.this.context, FromClauseBuilder.this.params, this.refInFilterToAlias(filtered), this.outer);
                filter.map(filterToSQL::toSQL).ifPresent(f -> {
                    this.add(FromClauseBuilder.AND);
                    this.add(FromClauseBuilder.LPAREN);
                    this.add((String)f);
                    this.add(FromClauseBuilder.RPAREN);
                });
            } else {
                this.add(onToSQL.toSQL(on));
            }
        }

        private void add(String txt) {
            this.sql.add(txt);
        }

        private Function<CqnElementRef, String> refInFilterToAlias(QatEntityNode entityNode) {
            String alias = entityNode.alias();
            CdsEntity entity = entityNode.rowType();
            SqlMapping toSql = FromClauseBuilder.this.getSqlMapping(entity);
            return ref -> {
                FromClauseBuilder.checkRef(ref);
                String elementName = ref.lastSegment();
                return alias + "." + toSql.columnName(elementName);
            };
        }

        private Function<CqnElementRef, String> refInOnToAlias(QatAssociationNode assoc) {
            String lhs = this.parentAlias(assoc);
            String rhs = assoc.alias();
            CdsEntity lhsType = ((QatEntityNode)assoc.parent()).rowType();
            CdsEntity rhsType = assoc.rowType();
            SqlMapping lhsToSql = FromClauseBuilder.this.getSqlMapping(lhsType);
            SqlMapping rhsToSql = FromClauseBuilder.this.getSqlMapping(rhsType);
            return ref -> {
                String columnName;
                String alias;
                FromClauseBuilder.checkRef(ref);
                Stream streamOfSegments = ref.stream();
                if (ref.size() > 1) {
                    streamOfSegments = streamOfSegments.skip(1L);
                }
                if (ref.firstSegment().equals(assoc.name())) {
                    alias = rhs;
                    columnName = rhsToSql.columnName(streamOfSegments);
                } else {
                    alias = lhs;
                    columnName = lhsToSql.columnName(streamOfSegments);
                }
                return alias + "." + columnName;
            };
        }

        private String parentAlias(QatAssociationNode assoc) {
            QatNode parent = assoc.parent();
            if (parent instanceof QatEntityNode) {
                return ((QatEntityNode)assoc.parent()).alias();
            }
            throw new IllegalStateException("parent is no structured type");
        }

        private void subSelect(CqnSelect select, String alias) {
            this.add(FromClauseBuilder.LPAREN);
            SQLStatementBuilder.SQLStatement stmt = new SelectStatementBuilder(FromClauseBuilder.this.context, FromClauseBuilder.this.params, select, new ArrayDeque<QatSelectableNode>(), true).build();
            this.add(stmt.sql());
            this.add(FromClauseBuilder.RPAREN);
            this.add(alias);
        }

        private String viewName(CdsEntity cdsEntity, EnumSet<DraftUtils.Element> draftElements) {
            String tableName = this.tableName(cdsEntity, draftElements);
            String localParams = cdsEntity.params().map(p -> {
                PreparedCqnStmt.CqnParam param = new PreparedCqnStmt.CqnParam(p.getName(), p.getDefaultValue().orElse(null));
                param.type(((CdsSimpleType)p.getType().as(CdsSimpleType.class)).getType());
                FromClauseBuilder.this.params.add(param);
                return "?";
            }).collect(Collectors.joining(","));
            if (!localParams.isEmpty()) {
                tableName = tableName + FromClauseBuilder.LPAREN + localParams + FromClauseBuilder.RPAREN;
            }
            return tableName;
        }

        private String tableName(CdsEntity cdsEntity, EnumSet<DraftUtils.Element> draftElements) {
            TableNameResolver resolver = this.ignoreLocalizedViews() ? new PlainTableNameResolver() : FromClauseBuilder.this.context.getTableNameResolver();
            if (!this.ignoreDraftSubquery() && DraftUtils.isDraftEnabled((CdsStructuredType)cdsEntity) && !DraftUtils.isDraftView((CdsStructuredType)cdsEntity)) {
                return DraftUtils.activeEntity(FromClauseBuilder.this.context, resolver, cdsEntity, draftElements);
            }
            return resolver.tableName(cdsEntity);
        }

        private boolean ignoreLocalizedViews() {
            return FromClauseBuilder.this.hints.getOrDefault("ignoreLocalizedViews", false);
        }

        private boolean ignoreDraftSubquery() {
            return FromClauseBuilder.this.hints.getOrDefault("ignoreDraftSubqueries", false);
        }

        private void table(QatEntityNode node) {
            if (!DocStoreUtils.targetsDocStore((CdsStructuredType)node.rowType())) {
                String viewName = this.viewName(node.rowType(), FromClauseBuilder.draftElements(node));
                this.add(viewName);
            }
            this.add(node.alias());
        }

        private Stream<String> sql() {
            return this.sql.build();
        }
    }
}

