/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.sql;

import com.sap.cds.impl.sql.SQLHelper;
import com.sap.cds.jdbc.spi.FunctionMapper;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.cqn.CqnContainmentTest;
import com.sap.cds.ql.cqn.CqnLiteral;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.ql.impl.ExpressionVisitor;
import com.sap.cds.ql.impl.LeanModifier;

public class ContainsToLike {
    private static final char ESCAPE_CHAR = '\\';

    public static CqnPredicate transform(final FunctionMapper functionMapper, CqnPredicate pred) {
        return CQL.copy((CqnPredicate)pred, (Modifier)new LeanModifier(){

            public Predicate containment(CqnContainmentTest.Position position, CqnValue value, CqnValue term, boolean caseInsensitive) {
                CqnValue pattern = ContainsToLike.escapeTerm(position, term);
                return functionMapper.like(value, pattern, "\\", caseInsensitive);
            }
        });
    }

    private static CqnValue escapeTerm(final CqnContainmentTest.Position position, CqnValue term) {
        return ExpressionVisitor.copy((CqnValue)term, (Modifier)new LeanModifier(){

            public CqnValue literal(CqnLiteral<?> literal) {
                if (literal.isString()) {
                    String term = SQLHelper.escapeLikePattern('\\', (String)literal.asString().value());
                    switch (position) {
                        case START: {
                            term = term + '%';
                            break;
                        }
                        case ANY: {
                            term = '%' + term + '%';
                            break;
                        }
                        case END: {
                            term = '%' + term;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("unexpected position: " + position);
                        }
                    }
                    return CQL.val((Object)term);
                }
                return literal;
            }
        });
    }
}

