/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.sql;

import com.sap.cds.impl.Context;
import com.sap.cds.impl.PreparedCqnStmt;
import com.sap.cds.impl.localized.LocaleUtils;
import com.sap.cds.jdbc.spi.SqlMapping;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.util.CdsModelUtils;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;

public interface SQLStatementBuilder {
    public SQLStatement build();

    public static <T> Stream<String> commaSeparated(Stream<T> stream, Function<T, String> f) {
        return stream.map(f).filter(t -> t != null).flatMap(e -> Stream.of(",", e)).skip(1L);
    }

    public static Stream<String> commaSeparated(Stream<String> stream) {
        return SQLStatementBuilder.commaSeparated(stream, v -> v);
    }

    public static Function<CqnElementRef, String> aliasResolver(Context context, CdsEntity entity) {
        SqlMapping sqlMapping = context.getDbContext().getSqlMapping((CdsStructuredType)entity);
        Optional collate = context.getDbContext().getStatementResolver().collate(context.getSessionContext().getLocale());
        if (collate.isPresent()) {
            LocaleUtils localeUtils = new LocaleUtils(context.getCdsModel(), context.getDataStoreConfiguration());
            String collateClause = " " + (String)collate.get();
            return ref -> {
                String column = sqlMapping.columnName(ref);
                CdsElement element = CdsModelUtils.element((CdsStructuredType)entity, (CqnElementRef)ref);
                if (localeUtils.requiresCollate(element)) {
                    column = column + collateClause;
                }
                return column;
            };
        }
        return arg_0 -> ((SqlMapping)sqlMapping).columnName(arg_0);
    }

    public static class SQLStatement {
        private final String sql;
        private final List<PreparedCqnStmt.Parameter> params;

        public SQLStatement(String sql, List<PreparedCqnStmt.Parameter> params) {
            this.sql = sql;
            this.params = params;
        }

        public String sql() {
            return this.sql;
        }

        public List<PreparedCqnStmt.Parameter> params() {
            return this.params;
        }
    }
}

