/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.sql;

import com.sap.cds.SessionContext;
import com.sap.cds.impl.Context;
import com.sap.cds.impl.PreparedCqnStmt;
import com.sap.cds.impl.builder.model.Disjunction;
import com.sap.cds.impl.builder.model.ExistsSubquery;
import com.sap.cds.impl.parser.token.CqnBoolLiteral;
import com.sap.cds.impl.qat.QatElementNode;
import com.sap.cds.impl.qat.QatEntityRootNode;
import com.sap.cds.impl.qat.QatSelectableNode;
import com.sap.cds.impl.sql.ContainsToLike;
import com.sap.cds.impl.sql.SQLHelper;
import com.sap.cds.impl.sql.SQLStatementBuilder;
import com.sap.cds.impl.sql.SelectStatementBuilder;
import com.sap.cds.impl.sql.SpaceSeparatedCollector;
import com.sap.cds.impl.util.Stack;
import com.sap.cds.jdbc.spi.DbContext;
import com.sap.cds.ql.cqn.CqnArithmeticExpression;
import com.sap.cds.ql.cqn.CqnBooleanLiteral;
import com.sap.cds.ql.cqn.CqnComparisonPredicate;
import com.sap.cds.ql.cqn.CqnConnectivePredicate;
import com.sap.cds.ql.cqn.CqnContainmentTest;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnExistsSubquery;
import com.sap.cds.ql.cqn.CqnExpression;
import com.sap.cds.ql.cqn.CqnFunc;
import com.sap.cds.ql.cqn.CqnInPredicate;
import com.sap.cds.ql.cqn.CqnListValue;
import com.sap.cds.ql.cqn.CqnLiteral;
import com.sap.cds.ql.cqn.CqnNegation;
import com.sap.cds.ql.cqn.CqnNullValue;
import com.sap.cds.ql.cqn.CqnNumericLiteral;
import com.sap.cds.ql.cqn.CqnParameter;
import com.sap.cds.ql.cqn.CqnPlain;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnStringLiteral;
import com.sap.cds.ql.cqn.CqnToken;
import com.sap.cds.ql.cqn.CqnVisitor;
import com.sap.cds.ql.impl.CqnNormalizer;
import com.sap.cds.ql.impl.Xpr;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.util.CqnStatementUtils;
import com.sap.cds.util.SessionUtils;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class TokenToSQLTransformer
implements Function<CqnToken, String> {
    public static final String SQL_TRUE = "TRUE";
    public static final String SQL_FALSE = "FALSE";
    private static final int SUBSTRING_START_PARAM = 1;
    private final Context context;
    private final List<PreparedCqnStmt.Parameter> params;
    private final Function<CqnElementRef, String> aliasResolver;
    private final Deque<QatSelectableNode> outer;
    private final boolean noCollating;
    private final Function<PreparedCqnStmt.Parameter, String> paramResolver;
    private final CqnNormalizer cqnNormalizer;
    private int parameterPosition = 0;

    public TokenToSQLTransformer(Context context, List<PreparedCqnStmt.Parameter> params, Function<CqnElementRef, String> aliasResolver, Deque<QatSelectableNode> outer, Function<PreparedCqnStmt.Parameter, String> paramResolver, boolean noCollating) {
        this.context = context;
        this.params = params;
        this.aliasResolver = aliasResolver;
        this.outer = outer;
        this.noCollating = noCollating;
        this.paramResolver = paramResolver;
        this.cqnNormalizer = new CqnNormalizer(context);
    }

    public TokenToSQLTransformer(Context context, List<PreparedCqnStmt.Parameter> params, Function<CqnElementRef, String> aliasResolver, Deque<QatSelectableNode> outer, boolean noCollating) {
        this(context, params, aliasResolver, outer, parameter -> "?", noCollating);
    }

    public static TokenToSQLTransformer notCollating(Context context, Function<CqnElementRef, String> aliasResolver, CdsEntity entity, String tableName, List<PreparedCqnStmt.Parameter> params, Function<PreparedCqnStmt.Parameter, String> paramResolver) {
        return new TokenToSQLTransformer(context, params, aliasResolver, TokenToSQLTransformer.outerQat(entity, tableName), paramResolver, true);
    }

    public static TokenToSQLTransformer notCollating(Context context, List<PreparedCqnStmt.Parameter> params, Function<CqnElementRef, String> aliasResolver, Deque<QatSelectableNode> outer) {
        return new TokenToSQLTransformer(context, params, aliasResolver, outer, true);
    }

    public static TokenToSQLTransformer notCollating(Context context, Function<CqnElementRef, String> aliasResolver, CdsEntity entity, String tableName, List<PreparedCqnStmt.Parameter> params) {
        return new TokenToSQLTransformer(context, params, aliasResolver, TokenToSQLTransformer.outerQat(entity, tableName), true);
    }

    private static Deque<QatSelectableNode> outerQat(CdsEntity entity, String tableName) {
        QatEntityRootNode root = new QatEntityRootNode(entity);
        entity.concreteNonAssociationElements().forEach(e -> root.addChild(new QatElementNode(root, (CdsElement)e)));
        root.setAlias(tableName);
        ArrayDeque<QatSelectableNode> outer = new ArrayDeque<QatSelectableNode>();
        outer.add(root);
        return outer;
    }

    public String toSQL(CqnPredicate pred) {
        DbContext dbContext = this.context.getDbContext();
        pred = (CqnPredicate)dbContext.getPredicateMapper().apply((Object)pred);
        pred = ContainsToLike.transform(dbContext.getFunctionMapper(), pred);
        if ((pred = CqnStatementUtils.simplifyPredicate((CqnPredicate)pred)) == CqnBoolLiteral.TRUE) {
            return null;
        }
        if (pred == CqnBoolLiteral.FALSE) {
            return "1 = 0";
        }
        return this.apply((CqnToken)pred);
    }

    @Override
    public String apply(CqnToken pred) {
        if (pred == null) {
            throw new IllegalArgumentException("predicate must not be null");
        }
        ToSQLVisitor visitor = new ToSQLVisitor();
        pred.accept((CqnVisitor)visitor);
        String sql = visitor.get(pred);
        if (pred instanceof Xpr) {
            sql = sql.substring(1, sql.length() - 1);
        }
        return sql;
    }

    class ToSQLVisitor
    implements CqnVisitor {
        Stack<String> stack = new Stack();

        ToSQLVisitor() {
        }

        public void visit(CqnParameter p) {
            String name = p.isPositional() ? String.valueOf(TokenToSQLTransformer.this.parameterPosition++) : p.name();
            PreparedCqnStmt.Parameter param = new PreparedCqnStmt.CqnParam(name).type(p.type());
            TokenToSQLTransformer.this.params.add(param);
            this.push((String)TokenToSQLTransformer.this.paramResolver.apply(param));
        }

        public void visit(CqnFunc cqnFunc) {
            String func = cqnFunc.func().toLowerCase(Locale.US);
            List args = this.stack.pop(cqnFunc.args().size());
            if ("substring".equals(func)) {
                args.set(1, (String)args.get(1) + " + 1");
            }
            this.push(TokenToSQLTransformer.this.context.getDbContext().getFunctionMapper().toSql(func, args));
        }

        public void visit(CqnListValue listValue) {
            int n = (int)listValue.values().count();
            String sql = this.stack.pop(n).stream().collect(Collectors.joining(", ", "(", ")"));
            this.push(sql);
        }

        public void visit(CqnContainmentTest test) {
            throw new IllegalStateException("CQN containment test should be transformed to LIKE predicate");
        }

        public void visit(CqnPlain plain) {
            this.push(plain.plain());
        }

        public void visit(CqnBooleanLiteral bool) {
            this.push(Boolean.TRUE.equals(bool.value()) ? TokenToSQLTransformer.SQL_TRUE : TokenToSQLTransformer.SQL_FALSE);
        }

        public void visit(CqnNumericLiteral<?> number) {
            Number val = number.value();
            if (number.isConstant() && this.isNonDecimal(val)) {
                this.push(String.valueOf(val));
            } else {
                this.valueParam((CqnLiteral<?>)number);
            }
        }

        private boolean isNonDecimal(Number number) {
            return number instanceof Integer || number instanceof Long || number instanceof Short;
        }

        public void visit(CqnStringLiteral literal) {
            if (literal.isConstant()) {
                this.push(SQLHelper.literal((String)literal.value()));
            } else {
                this.valueParam((CqnLiteral<?>)literal);
            }
        }

        public void visit(CqnLiteral<?> literal) {
            this.valueParam(literal);
        }

        private void valueParam(CqnLiteral<?> literal) {
            PreparedCqnStmt.Parameter param = new PreparedCqnStmt.ValueParam(() -> literal.value()).type(literal.type());
            TokenToSQLTransformer.this.params.add(param);
            this.push((String)TokenToSQLTransformer.this.paramResolver.apply(param));
        }

        private void valueParam(Supplier<Object> valueSupplier, CdsBaseType type) {
            PreparedCqnStmt.Parameter param = new PreparedCqnStmt.ValueParam(valueSupplier).type(type);
            TokenToSQLTransformer.this.params.add(param);
            this.push((String)TokenToSQLTransformer.this.paramResolver.apply(param));
        }

        public void visit(CqnNullValue nil) {
            this.push("NULL");
        }

        public void visit(CqnElementRef ref) {
            Optional sParam = SessionUtils.getSessionParameter((CqnElementRef)ref, (SessionContext)TokenToSQLTransformer.this.context.getSessionContext());
            if (sParam.isPresent()) {
                this.valueParam(((SessionUtils.SessionContextVariable)sParam.get()).getValueSupplier(), ((SessionUtils.SessionContextVariable)sParam.get()).getType());
            } else {
                this.push((String)TokenToSQLTransformer.this.aliasResolver.apply(ref));
            }
        }

        public void visit(CqnExistsSubquery exists) {
            ArrayDeque<QatSelectableNode> outerNodes;
            ExistsSubquery subQuery = (ExistsSubquery)exists;
            if (subQuery.getOuter() != null) {
                outerNodes = new ArrayDeque<QatSelectableNode>(TokenToSQLTransformer.this.outer);
                outerNodes.pop();
                outerNodes.add((QatSelectableNode)subQuery.getOuter());
            } else {
                outerNodes = TokenToSQLTransformer.this.outer;
            }
            CqnExistsSubquery normalized = TokenToSQLTransformer.this.cqnNormalizer.normalize(exists);
            SQLStatementBuilder.SQLStatement stmt = new SelectStatementBuilder(TokenToSQLTransformer.this.context, TokenToSQLTransformer.this.params, normalized.subquery(), outerNodes, TokenToSQLTransformer.this.noCollating).build();
            this.push("EXISTS (" + stmt.sql() + ")");
        }

        public void visit(CqnExpression xpr) {
            List snippets = this.stack.pop(((Xpr)xpr).length());
            this.push("(" + snippets.stream().collect(SpaceSeparatedCollector.joining()) + ")");
        }

        public void visit(CqnArithmeticExpression expr) {
            String right = (String)this.stack.pop();
            String left = (String)this.stack.pop();
            this.push("(" + left + " " + expr.operator().symbol() + " " + right + ")");
        }

        public void visit(CqnComparisonPredicate comparison) {
            String right = (String)this.stack.pop();
            String left = (String)this.stack.pop();
            this.push(left + " " + comparison.operator().symbol + " " + right);
        }

        public void visit(CqnConnectivePredicate connective) {
            String symbol = connective.operator().symbol;
            BiFunction<CqnPredicate, String, String> flattener = connective.operator() == CqnConnectivePredicate.Operator.AND ? this::flatAnd : this::flatOr;
            List original = connective.predicates();
            List snippets = this.stack.pop(original.size());
            StringBuilder sql = new StringBuilder();
            for (int i = 0; i < original.size(); ++i) {
                if (i > 0) {
                    sql.append(" ");
                    sql.append(symbol);
                    sql.append(" ");
                }
                sql.append(flattener.apply((CqnPredicate)original.get(i), (String)snippets.get(i)));
            }
            this.push(sql.toString());
        }

        private String flatAnd(CqnPredicate pred, String snippet) {
            if (pred instanceof Disjunction) {
                return "(" + snippet + ")";
            }
            return snippet;
        }

        String flatOr(CqnPredicate pred, String snippet) {
            return snippet;
        }

        public void visit(CqnInPredicate in) {
            String valueSet = (String)this.stack.pop();
            String value = (String)this.stack.pop();
            this.push(value + " in " + valueSet);
        }

        public void visit(CqnNegation neg) {
            if (neg.predicate() instanceof CqnConnectivePredicate) {
                this.push("not (" + (String)this.stack.pop() + ")");
            } else {
                this.push("not " + (String)this.stack.pop());
            }
        }

        private void push(String snippet) {
            this.stack.push((Object)snippet);
        }

        private String get(CqnToken pred) {
            if (this.stack.size() != 1) {
                throw new IllegalStateException("token " + pred.toJson() + " can't be mapped");
            }
            return (String)this.stack.pop();
        }
    }
}

