/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.jdbc.postgresql;

import com.sap.cds.impl.sql.SQLHelper;
import com.sap.cds.jdbc.spi.SessionVariableSetter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.stream.Collectors;

public class PostgreSqlSessionVariableSetter
implements SessionVariableSetter {
    public void set(Connection conn, String key, String value) throws SQLException {
        String sql = PostgreSqlSessionVariableSetter.sql(key, value);
        try (Statement stmt = conn.createStatement();){
            stmt.executeUpdate(sql);
        }
    }

    public void set(Connection conn, Map<String, String> contextVariables) throws SQLException {
        String sql = contextVariables.entrySet().stream().map(e -> PostgreSqlSessionVariableSetter.sql((String)e.getKey(), (String)e.getValue())).collect(Collectors.joining(";\n "));
        try (Statement stmt = conn.createStatement();){
            stmt.executeUpdate(sql);
        }
    }

    private static String sql(String key, String value) {
        StringBuilder builder = new StringBuilder("SET SESSION CAP.");
        String name = key.replace("-", "_");
        builder.append(name);
        if (value == null) {
            builder.append(" TO DEFAULT");
        } else {
            builder.append(" = ");
            builder.append(SQLHelper.literal(value));
        }
        return builder.toString();
    }
}

