/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.sql;

import com.sap.cds.impl.Context;
import com.sap.cds.impl.PreparedCqnStmt;
import com.sap.cds.impl.sql.SQLStatementBuilder;
import com.sap.cds.impl.sql.TokenToSQLTransformer;
import com.sap.cds.jdbc.spi.SqlMapping;
import com.sap.cds.ql.cqn.CqnDelete;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import java.util.ArrayList;
import java.util.List;

public class DeleteStatementBuilder
implements SQLStatementBuilder {
    private final CqnDelete delete;
    private final String tableName;
    private final TokenToSQLTransformer toSQL;
    private final List<PreparedCqnStmt.Parameter> params = new ArrayList<PreparedCqnStmt.Parameter>();

    public DeleteStatementBuilder(Context context, CqnDelete delete) {
        this.delete = delete;
        CdsEntity entity = context.getCdsModel().getEntity(delete.ref().firstSegment());
        SqlMapping sqlMapping = context.getDbContext().getSqlMapping((CdsStructuredType)entity);
        this.tableName = sqlMapping.tableName();
        this.toSQL = new TokenToSQLTransformer(context, arg_0 -> ((SqlMapping)sqlMapping).columnName(arg_0), entity, this.tableName, this.params);
    }

    @Override
    public SQLStatementBuilder.SQLStatement build() {
        StringBuilder builder = new StringBuilder();
        builder.append("DELETE FROM ");
        builder.append(this.tableName);
        this.delete.where().map(this.toSQL::toSQL).ifPresent(s -> {
            builder.append(" WHERE ");
            builder.append((String)s);
        });
        String sql = builder.toString();
        return new SQLStatementBuilder.SQLStatement(sql, this.params);
    }
}

