/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.docstore;

import com.google.common.annotations.VisibleForTesting;
import com.sap.cds.impl.Context;
import com.sap.cds.impl.PreparedCqnStmt;
import com.sap.cds.impl.docstore.DocStoreStatementBuilder;
import com.sap.cds.impl.docstore.DocStoreUtils;
import com.sap.cds.impl.sql.SQLStatementBuilder;
import com.sap.cds.impl.sql.SpaceSeparatedCollector;
import com.sap.cds.impl.sql.TokenToSQLTransformer;
import com.sap.cds.jdbc.spi.SqlMapping;
import com.sap.cds.ql.cqn.CqnUpdate;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DocStoreUpdateStatementBuilder
implements DocStoreStatementBuilder {
    private static final String DOUBLEQUOTE = "\"";
    private final CqnUpdate update;
    private final TokenToSQLTransformer toSql;
    private final SqlMapping sqlMapping;
    private final String tableName;
    private final CdsEntity entity;
    private final List<PreparedCqnStmt.Parameter> params = new ArrayList<PreparedCqnStmt.Parameter>();

    public DocStoreUpdateStatementBuilder(Context context, CqnUpdate update) {
        this.entity = context.getCdsModel().getEntity(update.ref().firstSegment());
        this.update = update;
        this.sqlMapping = context.getDbContext().getSqlMapping((CdsStructuredType)this.entity);
        this.tableName = this.sqlMapping.tableName();
        this.toSql = new TokenToSQLTransformer(context, arg_0 -> ((SqlMapping)this.sqlMapping).jsonObjectPath(arg_0), this.entity, this.tableName, this.params, DocStoreUtils::valueToParamCastExpression);
    }

    @VisibleForTesting
    static void flattenDataEntries(Map<String, Object> entries, Map<String, ParamType> parameters, String prefix) {
        parameters.putAll(entries.keySet().stream().filter(key -> !(entries.get(key) instanceof Map)).collect(Collectors.toMap(key -> DocStoreUpdateStatementBuilder.buildKey(prefix, key), key -> DocStoreUpdateStatementBuilder.valueToDocStoreType(entries.get(key)))));
        entries.keySet().stream().filter(key -> entries.get(key) instanceof Map).forEach(key -> DocStoreUpdateStatementBuilder.flattenDataEntries((Map)entries.get(key), parameters, DocStoreUpdateStatementBuilder.buildKey(prefix, key)));
    }

    private static String buildKey(String prefix, String key) {
        return prefix.isEmpty() ? key : prefix + "." + key;
    }

    static String quote(String key) {
        if (key.contains(".")) {
            return Arrays.stream(key.split("\\.")).map(element -> DOUBLEQUOTE + element + DOUBLEQUOTE).collect(Collectors.joining("."));
        }
        return DOUBLEQUOTE + key + DOUBLEQUOTE;
    }

    private static ParamType valueToDocStoreType(Object value) {
        String canonicalClassName = value.getClass().getCanonicalName();
        if (canonicalClassName.equals("java.lang.Boolean")) {
            return new ParamType(CdsBaseType.BOOLEAN, DocStoreUtils.hanaDocStoreTypeFromCdsBaseType(CdsBaseType.BOOLEAN));
        }
        if (canonicalClassName.equals("java.lang.Float") || canonicalClassName.equals("java.lang.Double") || canonicalClassName.equals("java.math.BigDecimal")) {
            return new ParamType(CdsBaseType.DOUBLE, DocStoreUtils.hanaDocStoreTypeFromCdsBaseType(CdsBaseType.DOUBLE));
        }
        if (canonicalClassName.equals("java.lang.Integer") || canonicalClassName.equals("java.lang.Long")) {
            return new ParamType(CdsBaseType.INTEGER64, DocStoreUtils.hanaDocStoreTypeFromCdsBaseType(CdsBaseType.INTEGER64));
        }
        return new ParamType(CdsBaseType.STRING, "NVARCHAR");
    }

    @Override
    public SQLStatementBuilder.SQLStatement build() {
        HashMap<String, ParamType> flattenedParameterMap = new HashMap<String, ParamType>();
        DocStoreUpdateStatementBuilder.flattenDataEntries(this.update.data(), flattenedParameterMap, "");
        flattenedParameterMap.keySet().forEach(param -> this.params.add(new PreparedCqnStmt.DataParam((String)param, ((ParamType)flattenedParameterMap.get((Object)param)).cdsBaseType)));
        Stream.Builder<String> builder = Stream.builder();
        builder.add("UPDATE");
        builder.add(this.tableName);
        builder.add("SET");
        builder.add(this.getSetStringWithParameterMarkers(flattenedParameterMap));
        this.update.where().map(this.toSql::toSQL).ifPresent(whereSql -> {
            builder.add("WHERE");
            builder.add((String)whereSql);
        });
        String sql = builder.build().collect(SpaceSeparatedCollector.joining());
        return new SQLStatementBuilder.SQLStatement(sql, this.params);
    }

    private String getSetStringWithParameterMarkers(Map<String, ParamType> flattenedParameterMap) {
        return flattenedParameterMap.keySet().stream().map(key -> String.format("%s = CAST(? AS %s)", DocStoreUpdateStatementBuilder.quote(key), ((ParamType)flattenedParameterMap.get((Object)key)).hanaType)).collect(Collectors.joining(", "));
    }

    @VisibleForTesting
    static class ParamType {
        private final CdsBaseType cdsBaseType;
        private final String hanaType;

        ParamType(CdsBaseType cdsBaseType, String hanaType) {
            this.cdsBaseType = cdsBaseType;
            this.hanaType = hanaType;
        }

        public CdsBaseType getCdsBaseType() {
            return this.cdsBaseType;
        }

        public String getHanaType() {
            return this.hanaType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ParamType)) {
                return false;
            }
            ParamType paramType = (ParamType)o;
            return this.cdsBaseType == paramType.cdsBaseType && this.hanaType.equals(paramType.hanaType);
        }

        public int hashCode() {
            return Objects.hash(this.cdsBaseType, this.hanaType);
        }
    }
}

