/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.sql;

import com.sap.cds.impl.Context;
import com.sap.cds.impl.PreparedCqnStmt;
import com.sap.cds.impl.builder.model.ElementRefImpl;
import com.sap.cds.impl.sql.SQLHelper;
import com.sap.cds.impl.sql.SQLStatementBuilder;
import com.sap.cds.jdbc.spi.SqlMapping;
import com.sap.cds.jdbc.spi.StatementResolver;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnUpsert;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.util.CdsModelUtils;
import java.util.ArrayList;
import java.util.stream.Stream;

public class UpsertStatementBuilder
implements SQLStatementBuilder {
    private final CqnUpsert upsert;
    private final SqlMapping sqlMapping;
    private final CdsEntity entity;
    private final StatementResolver statementResolver;

    public UpsertStatementBuilder(Context context, CqnUpsert upsert) {
        this.upsert = upsert;
        this.entity = context.getCdsModel().getEntity(upsert.ref().firstSegment());
        this.sqlMapping = context.getDbContext().getSqlMapping((CdsStructuredType)this.entity);
        this.statementResolver = context.getDbContext().getStatementResolver();
    }

    @Override
    public SQLStatementBuilder.SQLStatement build() {
        ArrayList<PreparedCqnStmt.Parameter> params = new ArrayList<PreparedCqnStmt.Parameter>();
        String tableName = this.sqlMapping.tableName();
        Stream<String> upsertColumnNames = this.upsert.elements().map(e -> {
            ElementRef ref = ElementRefImpl.parse((String)e);
            CdsElement element = CdsModelUtils.element((CdsStructuredType)this.entity, (CqnElementRef)ref);
            params.add(SQLHelper.param(e, element));
            return this.sqlMapping.columnName(element);
        });
        Stream<String> keyColumnNames = CdsModelUtils.concreteKeyNames((CdsStructuredType)this.entity).stream().map(arg_0 -> ((SqlMapping)this.sqlMapping).columnName(arg_0));
        Stream<String> paramMarkers = this.upsert.elements().map(c -> "?");
        String sql = this.statementResolver.upsert(tableName, keyColumnNames, upsertColumnNames, paramMarkers);
        return new SQLStatementBuilder.SQLStatement(sql, params);
    }
}

