/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.jdbc.hana;

import com.sap.cds.DataStoreConfiguration;
import com.sap.cds.impl.localized.LocaleUtils;
import com.sap.cds.impl.sql.SQLHelper;
import com.sap.cds.jdbc.spi.StatementResolver;
import com.sap.cds.ql.cqn.CqnLock;
import com.sap.cds.ql.cqn.CqnStatement;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class HanaStatementResolver
implements StatementResolver {
    private final DataStoreConfiguration dataStoreConfiguration;
    private final int majorVersion;

    public HanaStatementResolver(DataStoreConfiguration dataStoreConfiguration, int majorVersion) {
        this.dataStoreConfiguration = dataStoreConfiguration;
        this.majorVersion = majorVersion;
    }

    public Optional<String> collateClause(CqnStatement statement, Locale locale) {
        boolean ignoreLocaleOnHana = this.dataStoreConfiguration.getProperty("cds.sql.hana.ignore-locale", false);
        if (locale != null && !ignoreLocaleOnHana && this.statementNeedsCollateClause(statement)) {
            return Optional.of("with parameters('LOCALE' = " + SQLHelper.literal(LocaleUtils.getLocaleString((Locale)locale)) + ")");
        }
        return Optional.empty();
    }

    private boolean statementNeedsCollateClause(CqnStatement statement) {
        return statement.isDelete() && statement.asDelete().where().isPresent() || statement.isUpdate() && statement.asUpdate().where().isPresent() || statement.isSelect();
    }

    public String upsert(String table, Stream<String> keyColumns, Stream<String> upsertColumns, Stream<String> upsertValues) {
        String columns = SQLHelper.commaSeparated(upsertColumns);
        String values = SQLHelper.commaSeparated(upsertValues);
        return Stream.of("UPSERT", table, columns, "VALUES", values, "WITH PRIMARY KEY").collect(Collectors.joining(" "));
    }

    public String lockMode(CqnLock.Mode mode) {
        return switch (mode) {
            case CqnLock.Mode.SHARED -> {
                if (this.majorVersion >= 4) {
                    yield "FOR SHARE LOCK";
                }
            }
            default -> "FOR UPDATE";
        };
    }

    public Optional<String> timeoutClause(int timeoutSeconds) {
        if (timeoutSeconds > 0) {
            return Optional.of("WAIT " + timeoutSeconds);
        }
        return Optional.of("NOWAIT");
    }

    public Optional<String> hints(Map<String, Object> hints) {
        List hanaHints = hints.keySet().stream().filter(h -> h.startsWith("hdb.")).map(h -> h.substring(4)).collect(Collectors.toList());
        if (hanaHints.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(hanaHints.stream().collect(Collectors.joining(", ", "WITH HINT(", ")")));
    }
}

