/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.jdbc.postgresql;

import com.sap.cds.CdsDataStoreConnector;
import com.sap.cds.DataStoreConfiguration;
import com.sap.cds.jdbc.generic.GenericDbContext;
import com.sap.cds.jdbc.generic.LocaleVariableTableNameResolver;
import com.sap.cds.jdbc.postgresql.PostgreSqlExceptionAnalyzer;
import com.sap.cds.jdbc.postgresql.PostgreSqlFunctionMapper;
import com.sap.cds.jdbc.postgresql.PostgreSqlPredicateMapper;
import com.sap.cds.jdbc.postgresql.PostgreSqlSessionVariableSetter;
import com.sap.cds.jdbc.postgresql.PostgreSqlStatementResolver;
import com.sap.cds.jdbc.spi.ExceptionAnalyzer;
import com.sap.cds.jdbc.spi.FunctionMapper;
import com.sap.cds.jdbc.spi.PredicateMapper;
import com.sap.cds.jdbc.spi.SessionVariableSetter;
import com.sap.cds.jdbc.spi.StatementResolver;
import com.sap.cds.jdbc.spi.TableNameResolver;
import java.util.Locale;
import java.util.function.Function;

public final class PostgreSqlDbContext
extends GenericDbContext {
    @Override
    public FunctionMapper getFunctionMapper() {
        return new PostgreSqlFunctionMapper();
    }

    @Override
    public StatementResolver getStatementResolver() {
        return new PostgreSqlStatementResolver();
    }

    @Override
    public ExceptionAnalyzer getExceptionAnalyzer() {
        return new PostgreSqlExceptionAnalyzer();
    }

    public PostgreSqlDbContext(DataStoreConfiguration dataStoreConfiguration) {
        super(dataStoreConfiguration);
    }

    @Override
    public CdsDataStoreConnector.Capabilities getCapabilities() {
        return new CdsDataStoreConnector.Capabilities(){

            public int timestampPrecision() {
                return 6;
            }
        };
    }

    @Override
    public PredicateMapper getPredicateMapper() {
        return new PostgreSqlPredicateMapper();
    }

    @Override
    public SessionVariableSetter getSessionVariableSetter() {
        return new PostgreSqlSessionVariableSetter();
    }

    @Override
    public TableNameResolver createTableNameResolver(Locale locale) {
        return new LocaleVariableTableNameResolver(this::getSqlMapping, locale);
    }

    public Function<String, String> casing() {
        return name -> name.toLowerCase(Locale.US);
    }
}

