/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.jdbc.sqlite;

import com.sap.cds.jdbc.spi.SessionVariableSetter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Map;
import org.sqlite.Function;
import org.sqlite.SQLiteConnection;

public class SqliteSessionVariableSetter
implements SessionVariableSetter {
    public void set(Connection conn, String key, String value) throws SQLException {
        this.set(conn, Collections.singletonMap(key, value));
    }

    public void set(Connection conn, Map<String, String> contextVariables) throws SQLException {
        SQLiteConnection sqliteCon = conn.unwrap(SQLiteConnection.class);
        Function.create((Connection)sqliteCon, (String)"session_context", (Function)new SessionContextFunction(contextVariables));
    }

    private static class SessionContextFunction
    extends Function {
        private Map<String, String> contextVariables;

        public SessionContextFunction(Map<String, String> contextVariables) {
            this.contextVariables = contextVariables;
        }

        protected void xFunc() throws SQLException {
            String key;
            switch (key = this.value_text(0)) {
                case "$user.id": {
                    this.result(this.contextVariables.get("APPLICATIONUSER"));
                    break;
                }
                case "$user.locale": {
                    this.result(this.contextVariables.get("LOCALE"));
                    break;
                }
                case "$valid.from": 
                case "$at.from": {
                    this.result(SessionContextFunction.sqlTimestampToIso8601(this.contextVariables.get("VALID-FROM")));
                    break;
                }
                case "$valid.to": 
                case "$at.to": {
                    this.result(SessionContextFunction.sqlTimestampToIso8601(this.contextVariables.get("VALID-TO")));
                    break;
                }
                default: {
                    this.result();
                }
            }
        }

        private static String sqlTimestampToIso8601(String iso9075) {
            return Timestamp.valueOf(iso9075).toInstant().toString();
        }
    }
}

