/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl;

import com.sap.cds.CdsDataStore;
import com.sap.cds.CdsDataStoreConnector;
import com.sap.cds.CdsDataStoreException;
import com.sap.cds.CdsException;
import com.sap.cds.CdsLockTimeoutException;
import com.sap.cds.ResultBuilder;
import com.sap.cds.SessionContext;
import com.sap.cds.impl.AssociationLoader;
import com.sap.cds.impl.ConnectedClient;
import com.sap.cds.impl.Context;
import com.sap.cds.impl.ContextImpl;
import com.sap.cds.impl.ExceptionHandler;
import com.sap.cds.impl.JdbcDataSourceAdapter;
import com.sap.cds.impl.PreparedCqnStatement;
import com.sap.cds.impl.PreparedCqnStmt;
import com.sap.cds.impl.SQLDataSourceAdapter;
import com.sap.cds.impl.TimingLogger;
import com.sap.cds.impl.docstore.DocStoreUtils;
import com.sap.cds.impl.localized.LocaleUtils;
import com.sap.cds.impl.parser.JsonParser;
import com.sap.cds.impl.parser.StructDataParser;
import com.sap.cds.impl.parser.token.Jsonizer;
import com.sap.cds.impl.sql.SQLStatementBuilder;
import com.sap.cds.jdbc.spi.DbContext;
import com.sap.cds.jdbc.spi.ExceptionAnalyzer;
import com.sap.cds.jdbc.spi.ValueBinder;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.CdsDataException;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnExpand;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnSelectListValue;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.impl.ExpandProcessor;
import com.sap.cds.reflect.CdsArrayedType;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.transaction.TransactionManager;
import com.sap.cds.transaction.TransactionRequiredException;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.CqnStatementUtils;
import com.sap.cds.util.DataUtils;
import java.io.Reader;
import java.lang.reflect.UndeclaredThrowableException;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCClient
implements ConnectedClient {
    private static final Logger logger = LoggerFactory.getLogger(JDBCClient.class);
    private static final TimingLogger timed = new TimingLogger(logger);
    private static final Object INITIAL = new Object();
    private final Supplier<SQLDataSourceAdapter> adapter;
    private final TransactionManager transactionManager;
    private final Supplier<Connection> ds;
    private final ValueBinder binder;
    private final ExceptionAnalyzer exceptionAnalyzer;
    private final CdsDataStoreConnector.Capabilities capabilities;
    private final Map<String, Object> oldSessionVars = new HashMap<String, Object>();
    private Context context;
    private int maxBatchSize;

    public JDBCClient(Context context, Supplier<Connection> ds, TransactionManager transactionManager) {
        this.context = context;
        this.ds = ds;
        this.transactionManager = transactionManager;
        DbContext dbContext = context.getDbContext();
        this.binder = dbContext.getBinder(context.getSessionContext().getTimeZone());
        this.adapter = () -> new JdbcDataSourceAdapter(this.context);
        this.exceptionAnalyzer = context.getDbContext().getExceptionAnalyzer();
        this.capabilities = context.getDbContext().getCapabilities();
        this.maxBatchSize = JDBCClient.getMaxBatchSize(context);
    }

    @Override
    public PreparedCqnStatement prepare(CqnStatement statement) {
        if (statement.isSelect()) {
            return this.prepare(statement.asSelect());
        }
        SQLStatementBuilder.SQLStatement stmt = this.adapter.get().process(statement);
        CdsEntity root = CdsModelUtils.entity((CdsModel)this.context.getCdsModel(), (CqnStructuredTypeRef)statement.ref());
        CqnStructuredTypeRef ref = null;
        try {
            ref = statement.ref();
        }
        catch (CdsException cdsException) {
            // empty catch block
        }
        return PreparedCqnStmt.createUpdate(stmt.sql(), stmt.params(), ref, root);
    }

    public PreparedCqnStmt prepare(CqnSelect select) {
        CdsModel model = this.context.getCdsModel();
        CdsStructuredType targetType = CqnStatementUtils.targetType((CdsModel)model, (CqnSelect)select);
        CqnStructuredTypeRef ref = null;
        if (!CqnStatementUtils.containsPathExpression((Optional)select.where())) {
            ref = CqnStatementUtils.targetRef((CqnSelect)select);
        }
        List<ExpandProcessor> expandProcessors = Collections.emptyList();
        if (!DocStoreUtils.targetsDocStore(targetType)) {
            List<CqnSelectListItem> expands;
            boolean addKeys = !select.isDistinct() && select.groupBy().isEmpty() && CqnStatementUtils.containsRef((List)select.items());
            Map<Boolean, List<CqnSelectListItem>> items = select.items().stream().collect(Collectors.partitioningBy(CqnSelectListItem::isExpand));
            ((Select)select).columns(items.getOrDefault(Boolean.FALSE, Collections.emptyList()));
            if (addKeys) {
                Set keys = targetType.concreteNonAssociationElements().filter(e -> CdsModelUtils.isKey((CdsElement)e) && !e.getType().isStructured()).map(CdsElement::getName).collect(Collectors.toSet());
                CqnStatementUtils.selectHidden(keys, (CqnSelect)select);
            }
            if ((expands = items.get(Boolean.TRUE)) != null) {
                boolean optimizeToManyExpands = addKeys && ref != null;
                expandProcessors = new ArrayList<ExpandProcessor>(expands.size());
                for (CqnSelectListItem expand : expands) {
                    ExpandProcessor expandProcessor = ExpandProcessor.create(model, ref, targetType, (CqnExpand)expand, optimizeToManyExpands, select.hasLimit());
                    expandProcessor.addMappingKeys(select);
                    expandProcessors.add(expandProcessor);
                }
            }
        }
        SQLStatementBuilder.SQLStatement stmt = this.adapter.get().process((CqnStatement)select);
        return PreparedCqnStmt.create(stmt.sql(), select.items(), expandProcessors, select.excluding(), stmt.params(), ref, targetType);
    }

    private static int append(int[] arr, int[] elements, int pos) {
        System.arraycopy(elements, 0, arr, pos, elements.length);
        return pos + elements.length;
    }

    private static void rejectAutoCommit(Connection conn) throws SQLException {
        if (conn.getAutoCommit()) {
            throw new TransactionRequiredException("Connection must not be in auto-commit mode");
        }
    }

    private void setContextVariables(Map<String, Object> contextVariables) {
        DbContext dbCtx = this.context.getDbContext();
        try (Connection conn = this.ds.get();){
            dbCtx.getSessionVariableSetter().set(conn, contextVariables);
            this.oldSessionVars.putAll(contextVariables);
        }
        catch (SQLException e) {
            throw new CdsDataStoreException(String.format("Failed to set context variables %s", contextVariables), (Throwable)e);
        }
    }

    @Override
    public ResultBuilder executeQuery(PreparedCqnStatement preparedStmt, Map<String, Object> parameterValues, CdsDataStore dataStore, boolean isTransactionRequired) {
        List rows;
        if (isTransactionRequired) {
            this.requireTransaction();
        }
        PreparedCqnStmt pcqn = (PreparedCqnStmt)preparedStmt;
        String sql = pcqn.toNative();
        Object targetType = pcqn.targetType();
        List<PreparedCqnStmt.Parameter> params = pcqn.parameters();
        ValueBinder.Setter[] setters = this.createSetters(params);
        try (Connection conn = this.ds.get();){
            rows = (List)timed.debugSql(() -> {
                try (PreparedStatement pstmt = conn.prepareStatement(sql);){
                    List<Map<String, Object>> list;
                    block12: {
                        this.bindValues(pstmt, parameterValues, params, setters, (CdsStructuredType)targetType);
                        ResultSet rs = pstmt.executeQuery();
                        try {
                            list = this.result(pcqn, rs, dataStore);
                            if (rs == null) break block12;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return list;
                }
            }, sql, List::size);
        }
        catch (SQLException ex) {
            ExceptionHandler.chainNextExceptions(ex);
            if (this.exceptionAnalyzer.isLockTimeout(ex)) {
                throw new CdsLockTimeoutException(targetType);
            }
            throw new CdsDataStoreException("Error executing the statement", (Throwable)ex);
        }
        catch (UndeclaredThrowableException ex) {
            throw new CdsDataStoreException("Error executing the statement", (Throwable)ex);
        }
        pcqn.expands().stream().filter(ExpandProcessor::isPathExpand).forEach(processor -> processor.expand(rows, dataStore, parameterValues));
        pcqn.expands().stream().filter(ExpandProcessor::hasCountAndLimit).forEach(processor -> processor.inlineCount(rows, dataStore, parameterValues));
        if (!pcqn.excluding().isEmpty()) {
            rows.forEach(row -> row.keySet().removeAll(pcqn.excluding()));
        }
        return ResultBuilder.selectedRows((List)rows);
    }

    @Override
    public int[] executeUpdate(PreparedCqnStatement preparedStmt, List<Map<String, Object>> parameterValues) {
        int[] nArray;
        block9: {
            PreparedCqnStmt pcqn = (PreparedCqnStmt)preparedStmt;
            this.requireTransaction();
            String sql = pcqn.toNative();
            CdsEntity entity = (CdsEntity)pcqn.targetType();
            Connection conn = this.ds.get();
            try {
                int[] rowCount;
                nArray = rowCount = (int[])timed.debugSql(() -> {
                    JDBCClient.rejectAutoCommit(conn);
                    try (PreparedStatement pstmt = conn.prepareStatement(sql);){
                        List<PreparedCqnStmt.Parameter> params = pcqn.parameters();
                        if (parameterValues.size() > 1) {
                            int[] nArray = this.executeBatch(pstmt, params, parameterValues, entity);
                            return nArray;
                        }
                        Map<String, Object> values = this.firstEntry(parameterValues);
                        ValueBinder.Setter[] setters = this.createSetters(params);
                        this.bindValues(pstmt, values, params, setters, (CdsStructuredType)entity);
                        int[] nArray = new int[]{pstmt.executeUpdate()};
                        return nArray;
                    }
                }, sql, rc -> Arrays.stream(rc).sum());
                if (conn == null) break block9;
            }
            catch (Throwable rowCount) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable) {
                            rowCount.addSuppressed(throwable);
                        }
                    }
                    throw rowCount;
                }
                catch (CdsException e) {
                    throw e;
                }
                catch (Exception e) {
                    ExceptionHandler exHandler = new ExceptionHandler(entity, this.exceptionAnalyzer);
                    throw exHandler.cdsException(this.firstEntry(parameterValues), e);
                }
            }
            conn.close();
        }
        return nArray;
    }

    private int[] executeBatch(PreparedStatement pstmt, List<PreparedCqnStmt.Parameter> params, List<Map<String, Object>> entries, CdsEntity entity) throws SQLException {
        int row = 0;
        int rcPosition = 0;
        int[] result = new int[entries.size()];
        try {
            ValueBinder.Setter[] setters = this.createSetters(params);
            for (Map<String, Object> entry : entries) {
                this.bindValues(pstmt, entry, params, setters, (CdsStructuredType)entity);
                pstmt.addBatch();
                if (++row % this.maxBatchSize != 0) continue;
                int[] rc = pstmt.executeBatch();
                rcPosition = JDBCClient.append(result, rc, rcPosition);
            }
            int[] rc = pstmt.executeBatch();
            rcPosition = JDBCClient.append(result, rc, rcPosition);
            return result;
        }
        catch (BatchUpdateException ex) {
            ExceptionHandler.chainNextExceptions(ex);
            throw new ExceptionHandler(entity, this.exceptionAnalyzer).cdsBatchException(entries, rcPosition, ex);
        }
    }

    private ValueBinder.Setter[] createSetters(List<PreparedCqnStmt.Parameter> params) {
        int size = params.size();
        ValueBinder.Setter[] setters = new ValueBinder.Setter[size + 1];
        for (int col = 1; col <= size; ++col) {
            PreparedCqnStmt.Parameter param = params.get(col - 1);
            ValueBinder.Setter setter = this.binder.setter(param.type());
            setters[col] = (arg_0, arg_1, arg_2) -> ((ValueBinder.Setter)setter).set(arg_0, arg_1, arg_2);
        }
        return setters;
    }

    private void requireTransaction() {
        if (!this.transactionManager.isActive()) {
            throw new TransactionRequiredException();
        }
    }

    private void bindValues(PreparedStatement pstmt, Map<String, Object> values, List<PreparedCqnStmt.Parameter> params, ValueBinder.Setter[] binders, CdsStructuredType entity) throws SQLException {
        for (int col = 1; col <= params.size(); ++col) {
            PreparedCqnStmt.Parameter param = params.get(col - 1);
            Object value = param.get(values);
            if (value != null && Collection.class.isAssignableFrom(value.getClass())) {
                value = Jsonizer.json((Object)value);
            }
            try {
                binders[col].set(pstmt, col, value);
                continue;
            }
            catch (IllegalArgumentException | NullPointerException e) {
                throw new CdsDataException("Invalid value for '" + entity + "." + param.name() + "' of type " + param.type(), (Throwable)e);
            }
        }
    }

    private List<Map<String, Object>> result(PreparedCqnStmt pcqn, ResultSet dbResult, CdsDataStore dataStore) throws SQLException {
        Object targetType = pcqn.targetType();
        int columnCount = dbResult.getMetaData().getColumnCount();
        List<CqnSelectListValue> selectValues = pcqn.selectListItems().stream().flatMap(CqnSelectListItem::ofValue).collect(Collectors.toList());
        List<ExpandProcessor> parentKeyExpands = pcqn.expands().stream().filter(ExpandProcessor::isParentKeyExpand).collect(Collectors.toList());
        ColumnHandler[] columnHandlers = this.columnHandlers((CdsStructuredType)targetType, selectValues, columnCount);
        try {
            if (parentKeyExpands.isEmpty()) {
                ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
                while (dbResult.next()) {
                    rows.add(this.extractData(dbResult, selectValues, null, columnHandlers));
                }
                return rows;
            }
            return this.expandByParentKeys(dbResult, dataStore, parentKeyExpands, (CdsStructuredType)targetType, selectValues, columnHandlers);
        }
        catch (SQLException e) {
            ExceptionHandler.chainNextExceptions(e);
            throw new CdsDataStoreException("Failed to process result set", (Throwable)e);
        }
    }

    private List<Map<String, Object>> expandByParentKeys(ResultSet dbResult, CdsDataStore dataStore, List<ExpandProcessor> expands, CdsStructuredType targetType, List<CqnSelectListValue> selectList, ColumnHandler[] columnHandlers) throws SQLException {
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        while (dbResult.next()) {
            AssociationLoader assocLoader = new AssociationLoader(dataStore, targetType);
            Map<String, Object> data = this.extractData(dbResult, selectList, assocLoader, columnHandlers);
            for (ExpandProcessor expandProcessor : expands) {
                CqnExpand expand = expandProcessor.getExpand();
                if (logger.isDebugEnabled()) {
                    logger.debug("Expand {} using parent-keys", (Object)expand.ref());
                }
                assocLoader.expand(expand, data);
            }
            rows.add(data);
        }
        return rows;
    }

    private ColumnHandler[] columnHandlers(CdsStructuredType targetType, List<CqnSelectListValue> selectList, int columnCount) throws SQLException {
        ColumnHandler[] columnHandlers = new ColumnHandler[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            CqnSelectListValue slv = selectList.get(i);
            String displayName = slv.displayName();
            columnHandlers[i] = this.createHandler(targetType, slv, displayName);
        }
        return columnHandlers;
    }

    private ColumnHandler createHandler(CdsStructuredType targetType, CqnSelectListValue slv, String displayName) {
        Optional cdsType;
        if (slv.value().isRef()) {
            CqnElementRef ref = slv.asRef();
            CdsType type = CdsModelUtils.element((CdsStructuredType)targetType, (CqnElementRef)ref).getType();
            if (type.isArrayed()) {
                CdsType itemsType = ((CdsArrayedType)type.as(CdsArrayedType.class)).getItemsType();
                ValueBinder.Getter typeMapper = this.binder.getter(CdsBaseType.LARGE_STRING, false);
                ValueBinder.Getter valueExtractor = (result, col) -> {
                    String json = (String)typeMapper.get(result, col);
                    return StructDataParser.parseArrayOf((CdsType)itemsType, (String)json);
                };
                return new ColumnHandler(displayName, (ValueBinder.Getter<Object>)valueExtractor);
            }
            if (displayName.endsWith("$json")) {
                ValueBinder.Getter typeMapper = this.binder.getter(CdsBaseType.LARGE_STRING, true);
                ValueBinder.Getter valueExtractor = (result, col) -> {
                    Reader reader = (Reader)typeMapper.get(result, col);
                    if (reader == null) {
                        return Collections.emptyMap();
                    }
                    return JsonParser.map((Reader)reader);
                };
                String prefix = displayName.substring(0, displayName.lastIndexOf("$json"));
                return new ColumnHandler(prefix, (ValueBinder.Getter<Object>)valueExtractor);
            }
        }
        if (!(cdsType = CqnStatementUtils.getCdsType((CdsStructuredType)targetType, (CqnValue)slv.value())).isPresent()) {
            logger.debug("Cannot determine CDS type of {}", (Object)slv.value());
        }
        boolean mediaType = CqnStatementUtils.isMediaType((CdsStructuredType)targetType, (CqnSelectListItem)slv);
        ValueBinder.Getter valueExtractor = this.binder.getter((CdsBaseType)cdsType.orElse(null), mediaType);
        return new ColumnHandler(displayName, (ValueBinder.Getter<Object>)valueExtractor);
    }

    private Map<String, Object> extractData(ResultSet result, List<CqnSelectListValue> selectList, AssociationLoader assocLoader, ColumnHandler[] columnHandlers) throws SQLException {
        HashMap<String, Object> row = new HashMap<String, Object>(selectList.size());
        for (int i = 1; i <= columnHandlers.length; ++i) {
            ColumnHandler column = columnHandlers[i - 1];
            Object value = column.valueExtractor.get(result, i);
            CqnSelectListValue slv = selectList.get(i - 1);
            if (value instanceof Map) {
                this.mergeObject(row, slv, (Map)value, column.displayName);
                continue;
            }
            if (assocLoader != null) {
                assocLoader.addValueOfRootEntity(slv, value);
            }
            if (column.hidden) {
                DataUtils.createPath(row, (String)column.displayName, (value != null ? 1 : 0) != 0);
                continue;
            }
            if (column.structuringAlias) {
                DataUtils.resolvePathAndAdd(row, (String)column.displayName, (Object)value);
                continue;
            }
            row.put(column.displayName, value);
        }
        return row;
    }

    private void mergeObject(Map<String, Object> data, CqnSelectListValue slv, Map<String, Object> mapValue, String displayName) {
        CqnElementRef jsonRef = slv.asRef();
        mapValue.forEach((k, v) -> {
            ElementRef innerRef = CQL.to(jsonRef.segments().subList(0, jsonRef.segments().size() - 1)).get(k);
            ElementRef innerSlv = innerRef.as(displayName + k);
            DataUtils.resolvePathAndAdd((Map)data, (String)innerSlv.displayName(), (Object)v);
        });
    }

    private Map<String, Object> firstEntry(List<Map<String, Object>> valueList) {
        return valueList.isEmpty() ? Collections.emptyMap() : valueList.get(0);
    }

    @Override
    public void setSessionContext(SessionContext session) {
        String user;
        this.context = ContextImpl.context(this.context.getCdsModel(), this.context.getDbContext(), session, this.context.getDataStoreConfiguration());
        this.maxBatchSize = JDBCClient.getMaxBatchSize(this.context);
        HashMap<String, Object> contextVariables = new HashMap<String, Object>();
        String locale = LocaleUtils.getLocaleString((Locale)session.getLocale());
        if (!Objects.equals(this.oldSessionVars.getOrDefault("LOCALE", INITIAL), locale)) {
            contextVariables.put("LOCALE", locale);
        }
        Instant validFrom = session.getValidFrom();
        if (!Objects.equals(this.oldSessionVars.getOrDefault("VALID-FROM", INITIAL), validFrom)) {
            contextVariables.put("VALID-FROM", validFrom);
        }
        Instant validTo = session.getValidTo();
        if (!Objects.equals(this.oldSessionVars.getOrDefault("VALID-TO", INITIAL), validTo)) {
            contextVariables.put("VALID-TO", validTo);
        }
        String string = user = session.getUserContext().getId() != null ? session.getUserContext().getId() : null;
        if (!Objects.equals(this.oldSessionVars.getOrDefault("APPLICATIONUSER", INITIAL), user)) {
            contextVariables.put("APPLICATIONUSER", user);
        }
        if (!contextVariables.isEmpty()) {
            this.setContextVariables(contextVariables);
        }
    }

    private static int getMaxBatchSize(Context context) {
        return Math.max(1, context.getDataStoreConfiguration().getProperty("cds.sql.max-batch-size", 1000));
    }

    @Override
    public CdsDataStoreConnector.Capabilities capabilities() {
        return this.capabilities;
    }

    @Override
    public void setRollbackOnly() {
        this.transactionManager.setRollbackOnly();
    }

    private class ColumnHandler {
        final String displayName;
        final boolean hidden;
        final boolean structuringAlias;
        final ValueBinder.Getter<Object> valueExtractor;

        ColumnHandler(String displayName, ValueBinder.Getter<Object> valueExtractor) {
            this.displayName = displayName;
            this.hidden = displayName.endsWith("?");
            this.structuringAlias = displayName.contains(".");
            this.valueExtractor = valueExtractor;
        }
    }
}

