/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl;

import com.sap.cds.impl.Context;
import com.sap.cds.impl.PreparedCqnStmt;
import com.sap.cds.impl.SQLDataSourceAdapter;
import com.sap.cds.impl.docstore.DocStoreDeleteStatementBuilder;
import com.sap.cds.impl.docstore.DocStoreSelectStatementBuilder;
import com.sap.cds.impl.docstore.DocStoreUpdateStatementBuilder;
import com.sap.cds.impl.docstore.DocStoreUtils;
import com.sap.cds.impl.localized.LocaleUtils;
import com.sap.cds.impl.qat.QatSelectableNode;
import com.sap.cds.impl.sql.DeleteStatementBuilder;
import com.sap.cds.impl.sql.InsertStatementBuilder;
import com.sap.cds.impl.sql.SQLStatementBuilder;
import com.sap.cds.impl.sql.SelectStatementBuilder;
import com.sap.cds.impl.sql.UpdateStatementBuilder;
import com.sap.cds.impl.sql.UpsertStatementBuilder;
import com.sap.cds.ql.cqn.CqnFilterableStatement;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnStatement;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Optional;

public class JdbcDataSourceAdapter
implements SQLDataSourceAdapter {
    private static final ArrayDeque<QatSelectableNode> ROOT = new ArrayDeque();
    private final Context context;
    private final DocStoreUtils docStoreUtils;

    public JdbcDataSourceAdapter(Context context) {
        this.context = context;
        this.docStoreUtils = new DocStoreUtils(context.getCdsModel());
    }

    /*
     * Unable to fully structure code
     */
    private SQLStatementBuilder.SQLStatement appendCollation(SQLStatementBuilder.SQLStatement sqlStatement, CqnStatement statement) {
        locale = this.context.getSessionContext().getLocale();
        if (!(statement instanceof CqnFilterableStatement)) ** GOTO lbl-1000
        fs = (CqnFilterableStatement)statement;
        if (new LocaleUtils(this.context.getCdsModel()).collateClauseIsNeeded(fs, locale)) {
            collateClause = this.context.getDbContext().getStatementResolver().collateClause(statement, locale);
        } else lbl-1000:
        // 2 sources

        {
            collateClause = Optional.empty();
        }
        if (collateClause.isPresent()) {
            sql = String.join((CharSequence)" ", new CharSequence[]{sqlStatement.sql(), (CharSequence)collateClause.get()});
            return new SQLStatementBuilder.SQLStatement(sql, sqlStatement.params());
        }
        return sqlStatement;
    }

    @Override
    public SQLStatementBuilder.SQLStatement process(CqnStatement statement) {
        if (this.docStoreUtils.targetsDocStore(statement)) {
            return this.getDocStoreSqlStatement(statement);
        }
        return this.getColumnStoreSqlStatement(statement);
    }

    private SQLStatementBuilder.SQLStatement getDocStoreSqlStatement(CqnStatement statement) {
        this.assertThatDocStoreSupportIsEnabled();
        if (statement.isSelect()) {
            return new DocStoreSelectStatementBuilder(this.context, statement.asSelect()).build();
        }
        if (statement.isInsert()) {
            return DocStoreUtils.getDocStoreInsertStatement(statement.asInsert(), this.context);
        }
        if (statement.isUpdate()) {
            return new DocStoreUpdateStatementBuilder(this.context, statement.asUpdate()).build();
        }
        if (statement.isDelete()) {
            return new DocStoreDeleteStatementBuilder(this.context, statement.asDelete()).build();
        }
        throw new UnsupportedOperationException("Unsupported statement type: " + statement);
    }

    private SQLStatementBuilder.SQLStatement getColumnStoreSqlStatement(CqnStatement statement) {
        if (statement.isSelect()) {
            CqnSelect select = statement.asSelect();
            return this.appendCollation(new SelectStatementBuilder(this.context, new ArrayList<PreparedCqnStmt.Parameter>(), select, ROOT).build(), (CqnStatement)select);
        }
        if (statement.isInsert()) {
            return new InsertStatementBuilder(this.context, statement.asInsert()).build();
        }
        if (statement.isUpsert()) {
            return new UpsertStatementBuilder(this.context, statement.asUpsert()).build();
        }
        if (statement.isUpdate()) {
            return this.appendCollation(new UpdateStatementBuilder(this.context, statement.asUpdate()).build(), (CqnStatement)statement.asUpdate());
        }
        if (statement.isDelete()) {
            return this.appendCollation(new DeleteStatementBuilder(this.context, statement.asDelete()).build(), (CqnStatement)statement.asDelete());
        }
        throw new UnsupportedOperationException("Unsupported statement type: " + statement);
    }

    public void assertThatDocStoreSupportIsEnabled() {
        if (!this.context.getDataStoreConfiguration().getProperty("cds.sql.hana.docstore", false)) {
            throw new UnsupportedOperationException("Can't handle an entity annotated as doc-store enabled: DocStore integration is not enabled.");
        }
    }
}

