/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.qat;

import com.sap.cds.impl.qat.QatNode;
import com.sap.cds.impl.qat.QatSelectableNode;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import java.util.Optional;

public abstract class QatEntityNode
extends QatSelectableNode {
    private final CqnPredicate filter;
    private final boolean inSource;

    public QatEntityNode(QatNode parent, CdsEntity entity, Optional<CqnPredicate> filter, boolean inSource) {
        super(parent, (CdsStructuredType)entity);
        this.filter = filter.orElse(null);
        this.inSource = inSource;
    }

    public CdsEntity rowType() {
        return (CdsEntity)super.rowType();
    }

    @Override
    public boolean inSource() {
        return this.inSource;
    }

    public Optional<CqnPredicate> filter() {
        return Optional.ofNullable(this.filter);
    }

    @Override
    public String toString() {
        StringBuilder txt = new StringBuilder();
        if (this.alias() != null) {
            txt.append(this.alias());
            txt.append(" ");
        }
        txt.append(this.name());
        this.filter().ifPresent(f -> txt.append(" ").append(f.toJson()));
        return txt.toString();
    }
}

