/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.jdbc.generic;

import com.sap.cds.CdsDataStoreConnector;
import com.sap.cds.DataStoreConfiguration;
import com.sap.cds.impl.sql.SqlMappingImpl;
import com.sap.cds.jdbc.generic.GenericBinder;
import com.sap.cds.jdbc.generic.GenericExceptionAnalyzer;
import com.sap.cds.jdbc.generic.GenericFunctionMapper;
import com.sap.cds.jdbc.generic.GenericPredicateMapper;
import com.sap.cds.jdbc.generic.GenericSearchResolver;
import com.sap.cds.jdbc.generic.GenericSessionVariableSetter;
import com.sap.cds.jdbc.generic.GenericStatementResolver;
import com.sap.cds.jdbc.generic.LocaleVariableTableNameResolver;
import com.sap.cds.jdbc.spi.DbContext;
import com.sap.cds.jdbc.spi.ExceptionAnalyzer;
import com.sap.cds.jdbc.spi.FunctionMapper;
import com.sap.cds.jdbc.spi.PredicateMapper;
import com.sap.cds.jdbc.spi.SearchResolver;
import com.sap.cds.jdbc.spi.SessionVariableSetter;
import com.sap.cds.jdbc.spi.SqlMapping;
import com.sap.cds.jdbc.spi.StatementResolver;
import com.sap.cds.jdbc.spi.TableNameResolver;
import com.sap.cds.jdbc.spi.ValueBinder;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import java.util.Locale;
import java.util.TimeZone;

public abstract class GenericDbContext
implements DbContext {
    protected final DataStoreConfiguration config;

    protected GenericDbContext(DataStoreConfiguration dataStoreConfiguration) {
        this.config = dataStoreConfiguration;
    }

    public TableNameResolver createTableNameResolver(Locale locale) {
        return new LocaleVariableTableNameResolver(this::getSqlMapping, locale);
    }

    public SearchResolver createSearchResolver(CdsModel model, Locale locale) {
        return new GenericSearchResolver(model, locale);
    }

    public FunctionMapper getFunctionMapper() {
        return new GenericFunctionMapper();
    }

    public StatementResolver getStatementResolver() {
        return new GenericStatementResolver();
    }

    public ExceptionAnalyzer getExceptionAnalyzer() {
        return new GenericExceptionAnalyzer();
    }

    public CdsDataStoreConnector.Capabilities getCapabilities() {
        return CdsDataStoreConnector.Capabilities.ALL;
    }

    public PredicateMapper getPredicateMapper() {
        return new GenericPredicateMapper();
    }

    public ValueBinder getBinder(TimeZone timeZone) {
        return new GenericBinder(this.getCapabilities().timestampPrecision(), timeZone);
    }

    public SessionVariableSetter getSessionVariableSetter() {
        return new GenericSessionVariableSetter();
    }

    public SqlMapping getSqlMapping(CdsStructuredType rowType) {
        return new SqlMappingImpl(rowType, this.casing());
    }
}

