/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.jdbc.hana;

import com.sap.cds.impl.parser.token.CqnBoolLiteral;
import com.sap.cds.jdbc.generic.GenericPredicateMapper;
import com.sap.cds.jdbc.generic.GenericPredicateModifier;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnComparisonPredicate;
import com.sap.cds.ql.cqn.CqnListValue;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnSyntaxException;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.ql.impl.ExpressionVisitor;
import java.util.List;
import java.util.stream.Collectors;

public class HanaPredicateMapper
extends GenericPredicateMapper {
    @Override
    public CqnPredicate apply(CqnPredicate pred) {
        GenericPredicateModifier m = new GenericPredicateModifier(){

            @Override
            public CqnPredicate comparison(Value<?> lhs, CqnComparisonPredicate.Operator op, Value<?> rhs) {
                switch (op) {
                    case GT: 
                    case GE: 
                    case LT: 
                    case LE: {
                        if (!lhs.isList() || !rhs.isList()) break;
                        CqnListValue left = lhs.asList();
                        CqnListValue right = rhs.asList();
                        int n = left.size();
                        if (n != right.size()) {
                            throw new CqnSyntaxException("Only list values of same size can be compared");
                        }
                        List ls = left.values().collect(Collectors.toList());
                        List rs = right.values().collect(Collectors.toList());
                        CqnBoolLiteral p = CqnBoolLiteral.FALSE;
                        for (int i = 0; i < n; ++i) {
                            Predicate pi = CQL.comparison((CqnValue)((CqnValue)ls.get(i)), (CqnComparisonPredicate.Operator)op, (CqnValue)((CqnValue)rs.get(i)));
                            for (int j = i - 1; j >= 0; --j) {
                                Predicate pj = CQL.comparison((CqnValue)((CqnValue)ls.get(j)), (CqnComparisonPredicate.Operator)CqnComparisonPredicate.Operator.EQ, (CqnValue)((CqnValue)rs.get(j)));
                                pi = pj.and((CqnPredicate)pi, new CqnPredicate[0]);
                            }
                            p = p.or((CqnPredicate)pi, new CqnPredicate[0]);
                        }
                        return p;
                    }
                }
                return super.comparison(lhs, op, rhs);
            }
        };
        return ExpressionVisitor.copy((CqnPredicate)pred, (Modifier)m);
    }
}

