/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.jdbc.hana.search;

import com.sap.cds.impl.DraftUtils;
import com.sap.cds.impl.builder.model.Conjunction;
import com.sap.cds.impl.builder.model.ElementRefImpl;
import com.sap.cds.impl.builder.model.ListValue;
import com.sap.cds.impl.parser.token.CqnBoolLiteral;
import com.sap.cds.impl.util.Stack;
import com.sap.cds.jdbc.generic.AbstractSearchResolver;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.cqn.CqnConnectivePredicate;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnNegation;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSearchPredicate;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnSelectListValue;
import com.sap.cds.ql.cqn.CqnSource;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.cqn.CqnVisitor;
import com.sap.cds.ql.impl.SelectBuilder;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.CdsSearchUtils;
import com.sap.cds.util.CqnStatementUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HanaSearchResolver
extends AbstractSearchResolver {
    private static final Logger logger = LoggerFactory.getLogger(HanaSearchResolver.class);

    public HanaSearchResolver(CdsModel cdsModel, Locale locale) {
        super(cdsModel, locale);
    }

    private static CqnElementRef concatRefs(CqnElementRef prefix, CqnElementRef suffix) {
        int tail = suffix.size();
        ArrayList segs = new ArrayList(prefix.size() + tail - 1);
        segs.addAll(prefix.segments());
        segs.addAll(suffix.segments().subList(1, tail));
        return ElementRefImpl.elementRef(segs, null, null);
    }

    private static boolean isActiveEntity(CdsStructuredType targetType) {
        return DraftUtils.isDraftEnabled(targetType) && !DraftUtils.isDraftView(targetType);
    }

    @Override
    protected void resolve(CqnSelect select, CqnPredicate search, CdsStructuredType targetType, Collection<CqnElementRef> searchableRefs) {
        CdsEntity targetEntity = (CdsEntity)targetType;
        TreeSet<CqnElementRef> likeMainQuery = new TreeSet<CqnElementRef>(ElementRefComparator.INSTANCE);
        TreeSet<CqnElementRef> containsSubquery = new TreeSet<CqnElementRef>(ElementRefComparator.INSTANCE);
        TreeSet<CqnElementRef> containsMainQuery = new TreeSet<CqnElementRef>(ElementRefComparator.INSTANCE);
        boolean languageGiven = this.locale != null;
        boolean isActiveEntityOfDraft = false;
        boolean navigatesToManyAssoc = false;
        if ("generic".equalsIgnoreCase(HanaSearchResolver.getSearchModeAnnotation(targetType))) {
            logger.debug("All searchable refs in targetEntity {} will be searched with LIKE on the main querydue to annotation {}.", (Object)targetEntity, (Object)"@cds.sql.search.mode");
            likeMainQuery.addAll(searchableRefs);
        } else {
            for (CqnElementRef ref : searchableRefs) {
                CdsElement element = CdsModelUtils.element((CdsStructuredType)targetEntity, (CqnElementRef)ref);
                if (element.getType().isSimpleType(CdsBaseType.LARGE_STRING)) {
                    logger.debug("The searchable ref {} in targetEntity {} will be searched with LIKE since it's type LargeString is mapped to NCLOB on HANA. NCLOB cannot be searched with CONTAINS.", (Object)ref, (Object)targetEntity);
                    likeMainQuery.add(ref);
                } else if (this.isComputed(targetEntity, ref)) {
                    likeMainQuery.add(ref);
                } else if (element.isLocalized()) {
                    this.handleLocalizedElement(likeMainQuery, containsSubquery, containsMainQuery, languageGiven, ref, element);
                } else {
                    containsMainQuery.add(ref);
                }
                isActiveEntityOfDraft = isActiveEntityOfDraft || HanaSearchResolver.isDeclaredByActiveEntity(element);
                navigatesToManyAssoc = navigatesToManyAssoc || HanaSearchResolver.navigatesToManyAssoc((CdsStructuredType)targetEntity, ref);
            }
        }
        this.attachContainsAndLikeExpressionsToStatement(select, search, targetEntity, likeMainQuery, containsSubquery, containsMainQuery, isActiveEntityOfDraft, navigatesToManyAssoc);
    }

    private void handleLocalizedElement(Set<CqnElementRef> likeMainQuery, Set<CqnElementRef> containsSubquery, Set<CqnElementRef> containsMainQuery, boolean languageGiven, CqnElementRef ref, CdsElement element) {
        if (languageGiven) {
            if (HanaSearchResolver.isReachableViaLocalizedAssoc(element)) {
                containsSubquery.add(ref);
                containsSubquery.add(this.localizedRef(ref));
            } else {
                likeMainQuery.add(ref);
            }
        } else {
            containsMainQuery.add(ref);
        }
    }

    private void attachContainsAndLikeExpressionsToStatement(CqnSelect select, CqnPredicate search, CdsEntity targetEntity, Set<CqnElementRef> likeMainQuery, Set<CqnElementRef> containsSubquery, Set<CqnElementRef> containsMainQuery, boolean isActiveEntityOfDraft, boolean navigatesToManyAssoc) {
        CqnBoolLiteral filter = CqnBoolLiteral.FALSE;
        TreeSet<CqnElementRef> containsRefs = new TreeSet<CqnElementRef>(ElementRefComparator.INSTANCE);
        containsRefs.addAll(containsMainQuery);
        containsRefs.addAll(containsSubquery);
        if (logger.isDebugEnabled() && !containsRefs.isEmpty()) {
            String names = this.refNames(containsRefs);
            logger.debug("The following searchable element refs of {} that can be searched with CONTAINS: {}.", (Object)targetEntity, (Object)names);
        }
        CqnPredicate contains = this.searchToHanaContains(containsRefs, search);
        if (navigatesToManyAssoc || !containsSubquery.isEmpty() || !likeMainQuery.isEmpty() || isActiveEntityOfDraft) {
            contains = HanaSearchResolver.pushDownToExistsSubquery((CdsStructuredType)targetEntity, contains, true);
        }
        filter = CQL.or((CqnPredicate)filter, (CqnPredicate)contains);
        if (logger.isDebugEnabled() && !likeMainQuery.isEmpty()) {
            String names = this.refNames(likeMainQuery);
            logger.debug("The following searchable element refs of {} that can be searched with LIKE: {}.", (Object)targetEntity, (Object)names);
        }
        CqnPredicate like = CdsSearchUtils.searchToLikeExpression(likeMainQuery, (CqnPredicate)search);
        if (navigatesToManyAssoc) {
            like = HanaSearchResolver.pushDownToExistsSubquery((CdsStructuredType)targetEntity, like, true);
        }
        filter = CQL.or((CqnPredicate)filter, (CqnPredicate)like);
        CdsSearchUtils.moveSearchToWhere((CqnSelect)select, (CqnPredicate)filter);
    }

    private boolean isComputed(CdsEntity targetEntity, CqnElementRef ref) {
        if (Boolean.TRUE.equals(targetEntity.getAnnotationValue("@cds.persistence.exists", (Object)false))) {
            logger.debug("The searchable ref {} is treated as 'computed' as the targetEntity {} is annotated with {} and we cannot analyze computed refs.", new Object[]{ref, targetEntity, "@cds.persistence.exists"});
            return true;
        }
        if (!targetEntity.isView()) {
            return targetEntity.findElement(ref.path()).map(CdsElement::isCalculated).orElse(false);
        }
        Optional targetQuery = targetEntity.query();
        if (!targetQuery.isPresent()) {
            logger.debug("The searchable ref {} is treated as 'computed' as the targetEntity {} is a view with an unsupported query.", (Object)ref, (Object)targetEntity);
            return true;
        }
        CqnSelect query = (CqnSelect)targetQuery.get();
        CqnSource source = query.from();
        if (!source.isRef()) {
            logger.debug("The searchable ref {} is treated as 'computed' as the query {} of the targetEntity {} selects from a source which is not a ref {}.", new Object[]{ref, query, targetEntity, source});
            return true;
        }
        String startSegName = ref.firstSegment();
        Optional<CqnSelectListValue> match = query.items().stream().flatMap(CqnSelectListItem::ofValue).filter(slv -> slv.displayName().equals(startSegName)).findFirst();
        if (match.isPresent()) {
            CqnSelectListValue slv2 = match.get();
            if (!slv2.isRef()) {
                return true;
            }
            ref = HanaSearchResolver.concatRefs(slv2.asRef(), ref);
        }
        CqnStructuredTypeRef typeRef = query.ref();
        CdsEntity sourceEntity = CdsModelUtils.entity((CdsModel)this.model, (CqnStructuredTypeRef)typeRef);
        return this.isComputed(sourceEntity, ref);
    }

    private String refNames(Collection<CqnElementRef> refs) {
        return refs.stream().map(ref -> ref.asValue().displayName()).collect(Collectors.joining(","));
    }

    public void pushDownSearchToSubquery(CqnSelect select, CqnSelect subquery) {
        CqnPredicate merged = (CqnPredicate)Conjunction.and((Optional)subquery.search(), (Optional)select.search()).orElse(CqnBoolLiteral.TRUE);
        CqnSource source = subquery.from();
        if (source.isRef()) {
            CdsEntity targetEntity = CdsModelUtils.entity((CdsModel)this.model, (CqnStructuredTypeRef)subquery.ref());
            List resolved = CqnStatementUtils.resolveStar((List)subquery.items(), (Collection)subquery.excluding(), (CdsStructuredType)targetEntity, (boolean)false);
            Set exposed = resolved.stream().flatMap(CqnSelectListItem::ofRef).map(CqnReference::lastSegment).collect(Collectors.toSet());
            Set intersection = CdsSearchUtils.getSearchableElements((CqnSelect)subquery, (CdsStructuredType)targetEntity).stream().map(CqnReference::lastSegment).filter(exposed::contains).collect(Collectors.toSet());
            ((SelectBuilder)subquery.asSelect()).search(t -> (Predicate)merged, intersection);
        } else {
            ((SelectBuilder)subquery.asSelect()).search(merged);
        }
        ((SelectBuilder)select).search((CqnPredicate)null);
    }

    private static boolean isDeclaredByActiveEntity(CdsElement element) {
        CdsStructuredType declaringType = (CdsStructuredType)element.getDeclaringType();
        if (HanaSearchResolver.isActiveEntity(declaringType)) {
            logger.debug("Fallback to search with LIKE. Entity {} is draft-enabled which causes a subquery inSQL which prevents the usage of CONTAINS.", (Object)declaringType);
            return true;
        }
        return false;
    }

    private CqnPredicate searchToHanaContains(Collection<CqnElementRef> searchableRefs, CqnPredicate expression) {
        if (searchableRefs.isEmpty()) {
            return CqnBoolLiteral.FALSE;
        }
        ListValue refs = ListValue.of(searchableRefs);
        CqnValue searchExpression = this.cqnSearchPredicateToHanaContainsSearchString((CqnPredicate)CqnStatementUtils.simplifyPredicate((CqnPredicate)expression));
        return CQL.booleanFunc((String)"CONTAINS", Arrays.asList(refs, searchExpression));
    }

    private CqnValue cqnSearchPredicateToHanaContainsSearchString(CqnPredicate expression) {
        final Stack stack = new Stack();
        CqnVisitor visitor = new CqnVisitor(){

            public void visit(CqnSearchPredicate search) {
                String searchTerm = search.searchTerm();
                if (searchTerm.trim().contains(" ")) {
                    stack.push((Object)("*\"" + searchTerm + "\"*"));
                } else {
                    stack.push((Object)("*" + searchTerm + "*"));
                }
            }

            public void visit(CqnConnectivePredicate connective) {
                int n = connective.predicates().size();
                String delimiter = connective.operator() == CqnConnectivePredicate.Operator.AND ? " " : " OR ";
                stack.push((Object)String.join((CharSequence)delimiter, stack.pop(n)));
            }

            public void visit(CqnNegation cqnNegation) {
                stack.push((Object)("-" + (String)stack.pop()));
            }
        };
        expression.accept(visitor);
        if (stack.isEmpty()) {
            throw new IllegalStateException("the search term stack must not be empty!");
        }
        return CQL.val((Object)((String)stack.pop()));
    }

    private static class ElementRefComparator
    implements Comparator<CqnElementRef> {
        static final Comparator<CqnElementRef> INSTANCE = new ElementRefComparator();

        private ElementRefComparator() {
        }

        @Override
        public int compare(CqnElementRef ref1, CqnElementRef ref2) {
            int n2;
            List segs1 = ref1.segments();
            List segs2 = ref2.segments();
            int n1 = segs1.size();
            if (n1 > (n2 = segs2.size())) {
                return 1;
            }
            if (n1 < n2) {
                return -1;
            }
            for (int i = 0; i < n1; ++i) {
                String id2;
                String id1 = ((CqnReference.Segment)segs1.get(i)).id();
                int cmp = id1.compareTo(id2 = ((CqnReference.Segment)segs2.get(i)).id());
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        }
    }
}

