/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.ql.impl;

import com.google.common.base.Joiner;
import com.sap.cds.CdsDataStore;
import com.sap.cds.Result;
import com.sap.cds.impl.builder.model.ExpandBuilder;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.cqn.CqnComparisonPredicate;
import com.sap.cds.ql.cqn.CqnExpand;
import com.sap.cds.ql.cqn.CqnListValue;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.reflect.CdsAnnotation;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.CqnStatementUtils;
import com.sap.cds.util.DataUtils;
import com.sap.cds.util.OnConditionAnalyzer;
import com.sap.cds.util.PathExpressionResolver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpandProcessor {
    private static final Logger logger = LoggerFactory.getLogger(ExpandProcessor.class);
    private static final String EXPAND_USING_PARENT_KEYS = "parent-keys";
    private static final String EXPAND_USING_JOIN = "join";
    private static final String EXPAND_USING_SUBQUERY = "subquery";
    private static final String FK_PREFIX = "@fk:";
    private final CdsModel model;
    private final CqnStructuredTypeRef parentRef;
    private final CqnStructuredTypeRef expandRef;
    private final ExpandBuilder<?> expand;
    private Map<String, String> elementMapping;
    private Map<String, String> aliasMapping;
    private String expandMethod;
    private boolean queryWithLimit;

    private ExpandProcessor(CdsModel model, CqnStructuredTypeRef parentRef, CqnExpand expand, String expandMethod, boolean queryWithLimit) {
        this.model = model;
        this.expand = (ExpandBuilder)expand;
        this.expandRef = expand.ref();
        this.parentRef = parentRef;
        this.expandMethod = expandMethod;
        this.queryWithLimit = queryWithLimit;
    }

    public static ExpandProcessor create(CdsModel model, CqnStructuredTypeRef parentRef, CdsStructuredType parentType, CqnExpand expand, boolean pathExpand, boolean parentLimit) {
        boolean toOne = CqnStatementUtils.isToOnePath((CdsStructuredType)parentType, (List)expand.ref().segments());
        CdsElement assoc = CdsModelUtils.element((CdsStructuredType)parentType, (List)expand.ref().segments());
        String expandMethod = ExpandProcessor.determinExpandMethod(parentType, expand, assoc, toOne || !pathExpand);
        ExpandProcessor expandProcessor = new ExpandProcessor(model, parentRef, expand, expandMethod, parentLimit);
        if (expandProcessor.isPathExpand() || expandProcessor.hasCountAndLimit()) {
            expandProcessor.computeElementMapping(assoc);
        }
        return expandProcessor;
    }

    private static String determinExpandMethod(CdsStructuredType type, CqnExpand expand, CdsElement assoc, boolean parentKeys) {
        if (parentKeys || expand.hasLimit() || ((ExpandBuilder)expand).lazy()) {
            return EXPAND_USING_PARENT_KEYS;
        }
        return (String)assoc.findAnnotation("@cds.java.expand.using").map(CdsAnnotation::getValue).orElseGet(() -> ExpandProcessor.pathExpandMethod(type, expand));
    }

    private static String pathExpandMethod(CdsStructuredType type, CqnExpand expand) {
        if (CqnStatementUtils.isOneToManyPath((CdsStructuredType)type, (List)expand.ref().segments())) {
            return EXPAND_USING_JOIN;
        }
        return EXPAND_USING_SUBQUERY;
    }

    private void computeElementMapping(CdsElement assoc) {
        block2: {
            try {
                this.elementMapping = ExpandProcessor.fkMapping(this.expandRef, assoc);
                this.aliasMapping = new HashMap<String, String>(this.elementMapping.size());
                this.elementMapping.forEach((fk, v) -> {
                    String alias = FK_PREFIX + fk;
                    this.aliasMapping.put(alias, "@" + v.replace('.', '_'));
                });
            }
            catch (Exception e) {
                this.expandMethod = EXPAND_USING_PARENT_KEYS;
                if (!this.isPathExpand()) break block2;
                logger.debug("Cannot optimize to-many " + assoc.getQualifiedName() + " expand due to on condition", (Throwable)e);
            }
        }
    }

    private static Map<String, String> fkMapping(CqnStructuredTypeRef ref, CdsElement toManyAssoc) {
        HashMap<String, String> mapping = new HashMap<String, String>();
        new OnConditionAnalyzer(toManyAssoc, true).getFkMapping().forEach((k, val) -> {
            List segments = ref.stream().map(CqnReference.Segment::id).collect(Collectors.toList());
            if (val.isRef() && !val.asRef().firstSegment().startsWith("$")) {
                segments.set(segments.size() - 1, val.asRef().lastSegment());
                mapping.put((String)k, Joiner.on((char)'.').join(segments));
            }
        });
        return mapping;
    }

    public boolean isPathExpand() {
        return EXPAND_USING_JOIN.equals(this.expandMethod) || EXPAND_USING_SUBQUERY.equals(this.expandMethod);
    }

    public boolean isParentKeyExpand() {
        return EXPAND_USING_PARENT_KEYS.equals(this.expandMethod) || this.expandMethod == null;
    }

    public CqnExpand getExpand() {
        return this.expand;
    }

    public boolean hasCountAndLimit() {
        return this.expand.hasInlineCount() && this.expand.hasLimit();
    }

    public void addMappingKeys(CqnSelect select) {
        if (this.isPathExpand() || this.hasCountAndLimit() && !select.isDistinct() && select.groupBy().isEmpty()) {
            CqnStatementUtils.selectHidden(this.elementMapping.values(), (CqnSelect)select);
        }
    }

    public void expand(List<Map<String, Object>> rows, CdsDataStore dataStore, Map<String, Object> paramValues) {
        if (logger.isDebugEnabled()) {
            logger.debug("Expand to-many {} using {}", (Object)this.expand.ref(), (Object)this.expandMethod);
        }
        CqnSelect query = this.pathExpandQuery(rows);
        List expResult = dataStore.execute(query, paramValues).list();
        boolean addCount = this.expand.hasInlineCount() && !this.expand.hasLimit();
        DataUtils.merge(rows, (List)expResult, (String)this.expand.displayName(), this.aliasMapping, (String)FK_PREFIX, (boolean)addCount);
    }

    public void inlineCount(List<Map<String, Object>> rows, CdsDataStore dataStore, Map<String, Object> paramValues) {
        CqnSelect countQuery = this.countQuery();
        Result counts = dataStore.execute(countQuery, paramValues);
        DataUtils.addCounts(rows, (List)counts.list(), (String)this.expand.displayName(), this.aliasMapping);
    }

    private CqnSelect pathExpandQuery(List<Map<String, Object>> rows) {
        List<CqnSelectListItem> expItems = this.addFks(this.expand.items());
        StructuredType<?> target = ExpandProcessor.to((CqnReference)this.parentRef, (CqnReference)this.expand.ref());
        Select expQuery = Select.from(target).columns(expItems).orderBy(this.expand.orderBy());
        if (this.queryWithLimit) {
            expQuery.where(this.fkFilter(rows));
        }
        if (EXPAND_USING_SUBQUERY.equals(this.expandMethod)) {
            expQuery = PathExpressionResolver.resolvePath((CdsModel)this.model, (CqnSelect)expQuery);
        }
        return expQuery;
    }

    private CqnPredicate fkFilter(List<Map<String, Object>> rows) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>(rows.size());
        ArrayList<String> fks = new ArrayList<String>(this.elementMapping.keySet());
        CqnListValue fkElements = CQL.list(fks.stream().map(CQL::get).toList());
        List<String> parentKeys = fks.stream().map(fk -> CqnStatementUtils.hiddenName((String)this.elementMapping.get(fk))).toList();
        for (Map<String, Object> row : rows) {
            CqnListValue fkValues = CQL.list(parentKeys.stream().map(k -> CQL.val(row.get(k))).toList());
            predicates.add(CQL.comparison((CqnValue)fkElements, (CqnComparisonPredicate.Operator)CqnComparisonPredicate.Operator.EQ, (CqnValue)fkValues));
        }
        return CQL.or(predicates);
    }

    private CqnSelect countQuery() {
        List<CqnSelectListItem> items = this.addFks(new ArrayList<CqnSelectListItem>());
        List groupingColumns = items.stream().map(v -> v.asValue().value()).collect(Collectors.toList());
        items.add((CqnSelectListItem)CQL.count().as("count"));
        return Select.from(ExpandProcessor.to((CqnReference)this.parentRef, (CqnReference)this.expand.ref())).columns(items).groupBy(groupingColumns);
    }

    private List<CqnSelectListItem> addFks(List<CqnSelectListItem> expItems) {
        ArrayList<CqnSelectListItem> items = new ArrayList<CqnSelectListItem>(expItems);
        this.elementMapping.keySet().forEach(fk -> items.add((CqnSelectListItem)CQL.get((String)fk).as(FK_PREFIX + fk)));
        return items;
    }

    private static StructuredType<?> to(CqnReference ref1, CqnReference ref2) {
        ArrayList segments = new ArrayList(ref1.segments().size() + ref2.size());
        segments.addAll(ref1.segments());
        segments.addAll(ref2.segments());
        return CQL.to(segments);
    }
}

