/************************************************************************
 * © 2021-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 ************************************************************************/
package com.sap.cds.impl.docstore;

import static com.sap.cds.impl.sql.SpaceSeparatedCollector.joining;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

import com.sap.cds.impl.Context;
import com.sap.cds.impl.PreparedCqnStmt;
import com.sap.cds.impl.sql.SQLStatementBuilder;
import com.sap.cds.impl.sql.TokenToSQLTransformer;
import com.sap.cds.jdbc.spi.SqlMapping;
import com.sap.cds.ql.cqn.CqnDelete;
import com.sap.cds.reflect.CdsEntity;

public class DocStoreDeleteStatementBuilder implements DocStoreStatementBuilder {
	private final CqnDelete delete;
	private final TokenToSQLTransformer toSql;
	private final SqlMapping sqlMapping;
	private final String tableName;
	private final CdsEntity entity;
	private final List<PreparedCqnStmt.Parameter> params = new ArrayList<>();

	public DocStoreDeleteStatementBuilder(Context context, CqnDelete delete) {
		this.delete = delete;
		this.entity = context.getCdsModel().getEntity(this.delete.ref().firstSegment());
		this.sqlMapping = context.getDbContext().getSqlMapping(entity);
		this.tableName = this.sqlMapping.tableName();
		this.toSql = TokenToSQLTransformer.notCollating(context, sqlMapping::columnName, entity, this.tableName, params,
				DocStoreUtils::valueToParamCastExpression);
	}

	@Override
	public SQLStatementBuilder.SQLStatement build() {
		Stream.Builder<String> builder = Stream.builder();
		builder.add("DELETE FROM");
		builder.add(tableName);

		delete.where().map(toSql::toSQL).ifPresent(whereSql -> {
			builder.add("WHERE");
			builder.add(whereSql);
		});
		String sql = builder.build().collect(joining());

		return new SQLStatementBuilder.SQLStatement(sql, params);
	}
}
