/************************************************************************
 * © 2019-2023 SAP SE or an SAP affiliate company. All rights reserved. *
 ************************************************************************/
package com.sap.cds.impl.sql;

import static com.sap.cds.impl.sql.SQLStatementBuilder.aliasResolver;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

import com.sap.cds.impl.Context;
import com.sap.cds.impl.PreparedCqnStmt.Parameter;
import com.sap.cds.jdbc.spi.SqlMapping;
import com.sap.cds.ql.cqn.CqnDelete;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.reflect.CdsEntity;

public class DeleteStatementBuilder implements SQLStatementBuilder {

	private final CqnDelete delete;
	private final SqlMapping sqlMapping;
	private final String tableName;
	private final TokenToSQLTransformer toSQL;
	private final List<Parameter> params = new ArrayList<>();
	private final CdsEntity entity;

	public DeleteStatementBuilder(Context context, CqnDelete delete) {
		this.delete = delete;
		entity = context.getCdsModel().getEntity(delete.ref().firstSegment());
		sqlMapping = context.getDbContext().getSqlMapping(entity);
		tableName = sqlMapping.tableName();
		Function<CqnElementRef, String> aliasResolver = aliasResolver(context, entity);
		toSQL = TokenToSQLTransformer.notCollating(context, aliasResolver, entity, tableName, params);
	}

	@Override
	public SQLStatement build() {
		StringBuilder builder = new StringBuilder();
		builder.append("DELETE FROM ");
		builder.append(tableName);
		delete.where().map(w -> toSQL.toSQL(entity, w)).ifPresent(s -> {
			builder.append(" WHERE ");
			builder.append(s);
		});

		String sql = builder.toString();

		return new SQLStatement(sql, params);
	}

}
