/************************************************************************
 * © 2020-2023 SAP SE or an SAP affiliate company. All rights reserved. *
 ************************************************************************/
package com.sap.cds.jdbc.generic;

import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnComparisonPredicate.Operator;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.util.CqnStatementUtils;

public class GenericPredicateModifier implements Modifier {
	@Override
	public CqnPredicate comparison(Value<?> lhs, Operator op, Value<?> rhs) {
		switch (op) {
			case IS:
			case IS_NOT:
				CqnPredicate unfolded = CqnStatementUtils.unfold(CQL.comparison(lhs, op, rhs));
				return CQL.copy(unfolded, new UnfoldIsOperatorModifier());
			default:
				return CQL.comparison(lhs, op, rhs);
		}
	}

}