/*******************************************************************
 * © 2021 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.jdbc.h2;

import com.sap.cds.DataStoreConfiguration;
import com.sap.cds.jdbc.spi.DbContext;
import com.sap.cds.jdbc.spi.DbContextFactory;

public final class H2DbContextFactory implements DbContextFactory {
	@Override
	public boolean supports(String productName) {
		return "H2".equals(productName);
	}

	@Override
	public DbContext create(DataStoreConfiguration config, int majorVersion) {
		return new H2DbContext(config);
	}
};
