/*******************************************************************
 * © 2021 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.jdbc.hana;

import com.sap.cds.DataStoreConfiguration;
import com.sap.cds.jdbc.spi.DbContext;
import com.sap.cds.jdbc.spi.DbContextFactory;

public final class HanaDbContextFactory implements DbContextFactory {
	@Override
	public boolean supports(String productName) {
		return "HDB".equals(productName);
	}

	@Override
	public DbContext create(DataStoreConfiguration config, int majorVersion) {
		return new HanaDbContext(config, majorVersion);
	}
};
