/*******************************************************************
 * © 2024 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.jdbc.hana;

import com.sap.cds.jdbc.generic.GenericScalarValueResolver;
import com.sap.cds.jdbc.spi.ScalarValueResolver;
import com.sap.cds.ql.cqn.CqnParameter;
import com.sap.cds.ql.cqn.CqnVector;
import com.sap.cds.reflect.CdsBaseType;

public class HanaScalarValueResolver extends GenericScalarValueResolver {

	private static final String CAST_AS_REAL_VECTOR = "CAST(? AS REAL_VECTOR)";
	public static final ScalarValueResolver INSTANCE = new HanaScalarValueResolver();

	@Override
	public String parameter(CqnVector vector) {
		return CAST_AS_REAL_VECTOR;
	}

	@Override
	public String parameter(CqnParameter p) {
		return p.type().filter(CdsBaseType.VECTOR.cdsName()::equals).map(t -> CAST_AS_REAL_VECTOR).orElse("?");
	}

}
