/*******************************************************************
 * © 2024 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.jdbc.hana.json;

import com.sap.cds.jdbc.generic.GenericScalarValueResolver;
import com.sap.cds.jdbc.spi.ScalarValueResolver;
import com.sap.cds.ql.cqn.CqnBooleanLiteral;

public class HanaDocStoreScalarValueResolver extends GenericScalarValueResolver {

	private static final String JSON_TRUE = "TO_JSON_BOOLEAN(TRUE)";
	private static final String JSON_FALSE = "TO_JSON_BOOLEAN(FALSE)";

	public static final ScalarValueResolver INSTANCE = new HanaDocStoreScalarValueResolver();

	private HanaDocStoreScalarValueResolver() {
		// empty
	}

	@Override
	public String literal(CqnBooleanLiteral bool) {
		return Boolean.TRUE.equals(bool.value()) ? JSON_TRUE : JSON_FALSE;
	}
}
