/************************************************************************
 * © 2020-2023 SAP SE or an SAP affiliate company. All rights reserved. *
 ************************************************************************/
package com.sap.cds.jdbc.postgresql;

import java.util.Locale;
import java.util.function.Function;

import com.sap.cds.CdsDataStoreConnector.Capabilities;
import com.sap.cds.DataStoreConfiguration;
import com.sap.cds.jdbc.generic.GenericDbContext;
import com.sap.cds.jdbc.spi.ExceptionAnalyzer;
import com.sap.cds.jdbc.spi.FunctionMapper;
import com.sap.cds.jdbc.spi.PredicateMapper;
import com.sap.cds.jdbc.spi.SessionVariableSetter;
import com.sap.cds.jdbc.spi.StatementResolver;

public final class PostgreSqlDbContext extends GenericDbContext {

	static final int TIMESTAMP_PRECISION = 6;

	@Override
	public FunctionMapper getFunctionMapper() {
		return new PostgreSqlFunctionMapper();
	}

	@Override
	public StatementResolver getStatementResolver() {
		return new PostgreSqlStatementResolver();
	}

	@Override
	public ExceptionAnalyzer getExceptionAnalyzer() {
		return new PostgreSqlExceptionAnalyzer();
	}

	public PostgreSqlDbContext(DataStoreConfiguration dataStoreConfiguration) {
		super(dataStoreConfiguration);
	}

	@Override
	public Capabilities getCapabilities() {
		return new Capabilities() {
			@Override
			public int timestampPrecision() {
				return TIMESTAMP_PRECISION;
			}
		};
	}

	@Override
	public PredicateMapper getPredicateMapper() {
		return new PostgreSqlPredicateMapper();
	}

	@Override
	public SessionVariableSetter getSessionVariableSetter() {
		return new PostgreSqlSessionVariableSetter();
	}

	@Override
	public Function<String, String> casing() {
		return name -> name.toLowerCase(Locale.US);
	}
}
