/*******************************************************************
 * © 2021 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.jdbc.sqlite;

import java.sql.SQLException;

import com.sap.cds.jdbc.spi.ExceptionAnalyzer;

public class SqliteExceptionAnalyzer implements ExceptionAnalyzer {

	@Override
	public boolean isUniqueConstraint(SQLException ex) {
		return ex.getErrorCode() == 19 && ex.getMessage().contains("UNIQUE constraint failed");
	}

	@Override
	public boolean isNotNullConstraint(SQLException ex) {
		return ex.getErrorCode() == 19 && ex.getMessage().contains("NOT NULL constraint failed");
	}

	@Override
	public boolean isLockTimeout(SQLException ex) {
		return false;
	}
}
