/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.jdbc.hana.search;

import com.sap.cds.DataStoreConfiguration;
import com.sap.cds.impl.builder.model.ListValue;
import com.sap.cds.impl.parser.builder.ExpressionBuilder;
import com.sap.cds.jdbc.hana.search.HanaSearchResolver;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.cqn.CqnComparisonPredicate;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnToken;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import java.math.BigDecimal;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class HanaSearchResolverUsingScore
extends HanaSearchResolver {
    private static final String FUZZINESS_THRESHOLD_ANNOTATION = "@Search.fuzzinessThreshold";
    private static final String EXACT = "EXACT";
    private static final String FUZZY_MIN_SCORE = "FUZZY MINIMAL SCORE";
    private static final String SCM_SEARCH = "SIMILARITY CALCULATION MODE 'search'";
    private static final String SCM_TYPE_AHEAD = "SIMILARITY CALCULATION MODE 'type ahead'";

    public HanaSearchResolverUsingScore(DataStoreConfiguration config, CdsModel cdsModel, Locale locale) {
        super(config, cdsModel, locale);
    }

    @Override
    protected CqnPredicate searchToHana(Map<CqnElementRef, CdsElement> scoreRefs, CqnPredicate expression) {
        boolean fuzzy = this.fuzzySearch();
        HanaSearchResolver.SearchString searchString = HanaSearchResolverUsingScore.toSearchString(expression, fuzzy);
        ExpressionBuilder scoreBuilder = ExpressionBuilder.create((CqnToken[])new CqnToken[0]).plain("SCORE(").val((Object)searchString.searchString()).plain("IN");
        if (fuzzy && !searchString.containsWildcards()) {
            BigDecimal minScore = this.fuzzinessThreshold();
            HanaSearchResolverUsingScore.addScoreElements(scoreBuilder, scoreRefs, minScore);
        } else {
            scoreBuilder.add((CqnToken)ListValue.of(scoreRefs.keySet()));
            scoreBuilder.plain(EXACT);
        }
        scoreBuilder.plain(")");
        return CQL.comparison((CqnValue)scoreBuilder.value(), (CqnComparisonPredicate.Operator)CqnComparisonPredicate.Operator.GT, (CqnValue)CQL.constant((Object)0));
    }

    private static void addScoreElements(ExpressionBuilder score, Map<CqnElementRef, CdsElement> scoreRefs, BigDecimal minScore) {
        score.plain("(");
        int i = 0;
        int size = scoreRefs.size();
        for (Map.Entry<CqnElementRef, CdsElement> entry : scoreRefs.entrySet()) {
            CdsElement element = entry.getValue();
            score.add((CqnToken)entry.getKey());
            HanaSearchResolverUsingScore.scoringType(element, score, minScore);
            if (++i >= size) continue;
            score.plain(",");
        }
        score.plain(")");
    }

    private static void scoringType(CdsElement element, ExpressionBuilder score, BigDecimal minScore) {
        if ((minScore = HanaSearchResolverUsingScore.minScore(element, minScore)).compareTo(BigDecimal.ONE) < 0) {
            score.plain(FUZZY_MIN_SCORE);
            score.constant((Object)minScore);
            CdsType type = element.getType();
            if (HanaSearchResolverUsingScore.fuzzySearchMode(type)) {
                score.plain(SCM_SEARCH);
            } else if (type.isSimpleType(CdsBaseType.UUID)) {
                score.plain(SCM_TYPE_AHEAD);
            }
        } else {
            score.plain(EXACT);
        }
    }

    private static BigDecimal minScore(CdsElement element, BigDecimal minScore) {
        Number fuzziness = (Number)element.getAnnotationValue(FUZZINESS_THRESHOLD_ANNOTATION, (Object)minScore);
        if (fuzziness instanceof BigDecimal) {
            BigDecimal d = (BigDecimal)fuzziness;
            return d;
        }
        if (fuzziness instanceof Integer) {
            Integer i = (Integer)fuzziness;
            return BigDecimal.valueOf(i.intValue());
        }
        throw new IllegalArgumentException("Invalid fuzziness threshold: " + fuzziness);
    }

    private static boolean fuzzySearchMode(CdsType type) {
        return type.isSimpleType(CdsBaseType.STRING) || type.isSimpleType(CdsBaseType.LARGE_STRING);
    }

    @Override
    protected boolean needsPushToSubquery(CdsElement element) {
        return false;
    }

    @Override
    protected boolean handleLocalizedElement(CdsStructuredType targetType, Set<CqnElementRef> like, Map<CqnElementRef, CdsElement> score, boolean languageGiven, CqnElementRef ref, CdsElement element) {
        if (languageGiven && HanaSearchResolverUsingScore.isReachableViaLocalizedAssoc(element) && !this.searchLocalizedView(targetType)) {
            score.put(ref, element);
            score.put(this.localizedRef(ref), element);
            return true;
        }
        score.put(ref, element);
        return false;
    }

    private boolean searchLocalizedView(CdsStructuredType targetType) {
        String searchMode = (String)targetType.getAnnotationValue("@cds.sql.search.mode", (Object)this.configuredSearchMode());
        return "localized-view".equalsIgnoreCase(searchMode);
    }

    @Override
    protected void handleRegularElement(CdsStructuredType targetType, Set<CqnElementRef> like, Map<CqnElementRef, CdsElement> score, CqnElementRef ref, CdsElement element) {
        score.put(ref, element);
    }

    @Override
    protected void handleLargeStringElement(Set<CqnElementRef> like, Map<CqnElementRef, CdsElement> score, CdsStructuredType targetType, CqnElementRef ref, CdsElement element) {
        score.put(ref, element);
    }

    @Override
    protected String defaultSearchMode() {
        return "localized-association";
    }
}

