/*******************************************************************
 * © 2020 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.impl.qat;

import java.util.Optional;

import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.reflect.CdsEntity;

public final class QatEntityRootNode extends QatEntityNode {

	private final String name;

	public QatEntityRootNode(CdsEntity entity, Optional<CqnPredicate> filter) {
		super(null, entity, filter, true);
		this.name = entity.getQualifiedName();
	}

	public QatEntityRootNode(CdsEntity entity) {
		this(entity, Optional.empty());
	}

	@Override
	public String name() {
		return name;
	}

	@Override
	public void accept(QatVisitor visitor) {
		visitor.visit(this);
	}

}
