/************************************************************************
 * © 2022-2023 SAP SE or an SAP affiliate company. All rights reserved. *
 ************************************************************************/
package com.sap.cds.jdbc.postgresql;

import java.util.List;
import java.util.Locale;

import com.sap.cds.jdbc.generic.GenericFunctionMapper;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.cqn.CqnValue;

public class PostgreSqlFunctionMapper extends GenericFunctionMapper {

	@Override
	public String toSql(String cqnFunc, List<String> args) {
		String function = cqnFunc.toLowerCase(Locale.US);
		return switch (function) {
			case "matchespattern" -> genericFuncToSql("REGEXP_LIKE", args);
			default -> super.toSql(cqnFunc, args);
		};
	}

	@Override
	public Predicate like(CqnValue value, CqnValue pattern, String esc, boolean caseInsensitive) {
		return ilike(value, pattern, esc, caseInsensitive);
	}

}
