/*******************************************************************
 * © 2019 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.jdbc.sqlite;

import java.util.List;
import java.util.Locale;

import com.sap.cds.jdbc.generic.GenericFunctionMapper;

public class SqliteFunctionMapper extends GenericFunctionMapper {

	@Override
	public String toSql(String cqnFunc, List<String> args) {
		String func = cqnFunc.toLowerCase(Locale.US);
		switch (func) {
		case "substring":
			return genericFuncToSql("substr", args);
		default:
			return super.toSql(cqnFunc, args);
		}
	}

}
