/*******************************************************************
 * © 2023 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.jdbc.sqlite;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;

import org.sqlite.Function;
import org.sqlite.SQLiteConnection;

import com.sap.cds.jdbc.spi.SessionVariableSetter;
import com.sap.cds.jdbc.sqlite.functions.LikeRegexpFunction;
import com.sap.cds.jdbc.sqlite.functions.SessionContextFunction;

public class SqliteSessionVariableSetter implements SessionVariableSetter {

	@Override
	public void set(Connection conn, Map<String, Object> contextVariables) throws SQLException {
		SQLiteConnection sqliteCon = conn.unwrap(SQLiteConnection.class);
		Function.create(sqliteCon, "session_context", new SessionContextFunction(contextVariables));
		Function.create(sqliteCon, "LIKE_REGEX", new LikeRegexpFunction(), 3, 0);
	}

}
