/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl;

import com.sap.cds.impl.Context;
import com.sap.cds.impl.parser.token.CqnBoolLiteral;
import com.sap.cds.impl.parser.token.RefSegmentImpl;
import com.sap.cds.jdbc.spi.TableNameResolver;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnSelectListValue;
import com.sap.cds.ql.cqn.CqnSortSpecification;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.ql.impl.ExpressionVisitor;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.util.CdsModelUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class DraftUtils {
    private static final String DRAFT_ANNOTATION = "odata.draft.enabled";
    private static final String DRAFT_PREPARE_ANNOTATION = "Common.DraftNode.PreparationAction";
    private static final String DRAFT = "_drafts";

    public static boolean isDraftEnabled(CdsStructuredType targetType) {
        return (Boolean)targetType.getAnnotationValue(DRAFT_ANNOTATION, (Object)false) != false || targetType.findAnnotation(DRAFT_PREPARE_ANNOTATION).isPresent();
    }

    public static boolean isDraftView(CdsStructuredType type) {
        return type.getQualifiedName().endsWith(DRAFT);
    }

    public static boolean isActive(CdsStructuredType type) {
        return DraftUtils.isDraftEnabled(type) && !DraftUtils.isDraftView(type);
    }

    public static String activeEntity(Context context, TableNameResolver tableResolver, CdsEntity cdsEntity, Set<Element> draftElements) {
        String table = tableResolver.tableName(cdsEntity);
        if (draftElements.isEmpty()) {
            return table;
        }
        StringBuilder subquery = new StringBuilder("(SELECT ACTIVE.*");
        if (draftElements.contains((Object)Element.IS_ACTIVE)) {
            subquery.append(", true as IsActiveEntity");
        }
        if (draftElements.contains((Object)Element.HAS_ACTIVE)) {
            subquery.append(", false as HasActiveEntity");
        }
        boolean joinInactive = false;
        if (draftElements.contains((Object)Element.HAS_DRAFT)) {
            subquery.append(", COALESCE(DRAFT.HasActiveEntity, false) as HasDraftEntity");
            joinInactive = true;
        }
        if (draftElements.contains((Object)Element.DRAFT_UUID)) {
            subquery.append(", DRAFT.DraftAdministrativeData_DraftUUID as DraftAdministrativeData_DraftUUID");
            joinInactive = true;
        }
        subquery.append(" from ");
        subquery.append(table);
        subquery.append(" ACTIVE");
        if (joinInactive) {
            String draftEntityName = cdsEntity.getQualifiedName() + DRAFT;
            String draftTable = tableResolver.tableName(context.getCdsModel().getEntity(draftEntityName));
            subquery.append(" left outer join ");
            subquery.append(draftTable);
            subquery.append(" DRAFT on ");
            subquery.append(DraftUtils.on(context, cdsEntity));
        }
        subquery.append(")");
        return subquery.toString();
    }

    private static String on(Context context, CdsEntity cdsEntity) {
        return cdsEntity.concreteNonAssociationElements().filter(CdsModelUtils::isKey).sorted(Comparator.comparing(CdsElement::getName)).map(e -> context.getDbContext().getSqlMapping((CdsStructuredType)cdsEntity).columnName(e)).map(n -> "ACTIVE." + n + " = DRAFT." + n).collect(Collectors.joining(" AND "));
    }

    public static Optional<Element> draftElement(CdsElement element) {
        return DraftUtils.draftElement(element.getName());
    }

    public static Optional<Element> draftElement(String name) {
        for (Element e : Element.values()) {
            if (!e.name.equals(name)) continue;
            return Optional.of(e);
        }
        return Optional.empty();
    }

    public static CqnSelect resolveConstantElements(final CdsModel model, CdsStructuredType target, CqnSelect select) {
        if (!DraftUtils.isActive(target)) {
            return select;
        }
        final ReplaceIsActiveModifier modifier = new ReplaceIsActiveModifier(target);
        select = (CqnSelect)CQL.copy((CqnStatement)select, (Modifier)new Modifier(){

            public CqnStructuredTypeRef ref(CqnStructuredTypeRef ref) {
                CdsEntity type = model.getEntity(ref.firstSegment());
                List original = ref.segments();
                ArrayList<CqnReference.Segment> copy = new ArrayList<CqnReference.Segment>(original.size());
                boolean changed = false;
                Iterator iter = original.iterator();
                CqnReference.Segment seg = (CqnReference.Segment)iter.next();
                while (true) {
                    CqnReference.Segment s = seg;
                    if (DraftUtils.isActive((CdsStructuredType)type) && seg.filter().isPresent()) {
                        Predicate filter = CQL.copy((CqnPredicate)((CqnPredicate)seg.filter().get()), (Modifier)new ReplaceIsActiveModifier((CdsStructuredType)type));
                        s = RefSegmentImpl.refSegment((String)seg.id(), (CqnPredicate)filter);
                        changed = true;
                    }
                    copy.add(s);
                    if (!iter.hasNext()) break;
                    seg = (CqnReference.Segment)iter.next();
                    type = type.getTargetOf(seg.id());
                }
                if (changed) {
                    return CQL.to(copy).asRef();
                }
                return ref;
            }

            public Predicate where(Predicate where) {
                return CQL.copy((CqnPredicate)where, (Modifier)modifier);
            }

            public CqnSortSpecification sort(Value<?> value, CqnSortSpecification.Order order) {
                CqnValue val = ExpressionVisitor.copy(value, (Modifier)modifier);
                return CQL.sort((CqnValue)val, (CqnSortSpecification.Order)order);
            }

            public List<CqnSelectListItem> items(List<CqnSelectListItem> items) {
                ArrayList<CqnSelectListItem> newItems = new ArrayList<CqnSelectListItem>(items.size());
                for (CqnSelectListItem sli : items) {
                    if (sli.isValue()) {
                        CqnSelectListValue slv = sli.asValue();
                        String displayName = slv.displayName();
                        CqnElementRef ref = null;
                        if (slv.isRef()) {
                            ref = slv.asRef();
                        } else if (slv.value().isRef()) {
                            ref = slv.value().asRef();
                        }
                        if (ref != null && ref.size() == 1) {
                            switch (ref.lastSegment()) {
                                case "IsActiveEntity": {
                                    sli = CqnBoolLiteral.TRUE.as(displayName);
                                    break;
                                }
                                case "HasActiveEntity": {
                                    sli = CqnBoolLiteral.FALSE.as(displayName);
                                }
                            }
                        }
                    }
                    newItems.add(sli);
                }
                return newItems;
            }
        });
        return select;
    }

    public static enum Element {
        IS_ACTIVE("IsActiveEntity"),
        HAS_ACTIVE("HasActiveEntity"),
        HAS_DRAFT("HasDraftEntity"),
        DRAFT_UUID("DraftAdministrativeData_DraftUUID");

        private final String name;

        private Element(String name) {
            this.name = name;
        }
    }

    private static final class ReplaceIsActiveModifier
    implements Modifier {
        private final CdsStructuredType target;

        public ReplaceIsActiveModifier(CdsStructuredType target) {
            this.target = target;
        }

        public CqnValue ref(CqnElementRef ref) {
            CdsStructuredType declaringType = this.target;
            Iterator iter = ref.segments().iterator();
            CqnReference.Segment seg = (CqnReference.Segment)iter.next();
            while (iter.hasNext()) {
                declaringType = declaringType.getTargetOf(seg.id());
                seg = (CqnReference.Segment)iter.next();
            }
            if (!DraftUtils.isActive(declaringType)) {
                return ref;
            }
            switch (seg.id()) {
                case "IsActiveEntity": {
                    return CqnBoolLiteral.TRUE;
                }
                case "HasActiveEntity": {
                    return CqnBoolLiteral.FALSE;
                }
            }
            return ref;
        }
    }
}

