/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl;

import com.sap.cds.CdsDataStoreException;
import com.sap.cds.CdsException;
import com.sap.cds.NotNullConstraintException;
import com.sap.cds.UniqueConstraintException;
import com.sap.cds.jdbc.spi.ExceptionAnalyzer;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.impl.CdsAnnotatableImpl;
import com.sap.cds.util.CdsModelUtils;
import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ExceptionHandler {
    private final CdsEntity entity;
    private final ExceptionAnalyzer exceptionAnalyzer;

    public ExceptionHandler(CdsEntity entity, ExceptionAnalyzer exceptionAnalyzer) {
        this.entity = entity;
        this.exceptionAnalyzer = exceptionAnalyzer;
    }

    public CdsException cdsBatchException(List<Map<String, Object>> entries, int updatedCount, BatchUpdateException ex) {
        if (this.exceptionAnalyzer.isUniqueConstraint((SQLException)ex)) {
            return new BatchExceptionHandler(this.entity).uniqueConstraint(entries, updatedCount, ex);
        }
        if (this.exceptionAnalyzer.isNotNullConstraint((SQLException)ex)) {
            return new BatchExceptionHandler(this.entity).notNullConstraint(entries, updatedCount, ex);
        }
        return new CdsDataStoreException("Error executing the statement", (Throwable)ex);
    }

    public CdsException cdsException(Map<String, Object> entryValues, Exception ex) {
        Throwable cause = ExceptionAnalyzer.getRootCause((Throwable)ex);
        if (cause instanceof SQLException) {
            SQLException sqlEx = (SQLException)cause;
            if (this.exceptionAnalyzer.isUniqueConstraint(sqlEx)) {
                return new UniqueConstraintException(this.entity, entryValues, CdsModelUtils.concreteKeyNames((CdsStructuredType)this.entity), ex);
            }
            if (this.exceptionAnalyzer.isNotNullConstraint(sqlEx)) {
                return ExceptionHandler.notNullConstraintException(this.entity, entryValues, ex);
            }
        }
        return new CdsDataStoreException("Error executing the statement", (Throwable)ex);
    }

    public static void chainNextExceptions(SQLException ex) {
        SQLException next = ex.getNextException();
        if (ex.getCause() == null && next != null) {
            ex.initCause(next);
        }
    }

    private static List<CdsElement> getNullValuedNotNullableElements(CdsEntity entity, Map<String, Object> entry) {
        Stream<CdsElement> nullKeys = entity.keyElements().filter(e -> null == entry.get(e.getName()));
        Stream<CdsElement> notNullEls = entity.elements().filter(e -> (e.isNotNull() || e.findAnnotation(CdsAnnotatableImpl.removeAt((String)"@cds.valid.from")).isPresent()) && null == entry.get(e.getName()));
        return Stream.concat(nullKeys, notNullEls).collect(Collectors.toList());
    }

    private static CdsException notNullConstraintException(CdsEntity entity, Map<String, Object> entryValues, Exception ex) {
        List<CdsElement> nonNullableElements = ExceptionHandler.getNullValuedNotNullableElements(entity, entryValues);
        if (nonNullableElements.isEmpty()) {
            return new CdsDataStoreException("Error executing the statement", (Throwable)ex);
        }
        return new NotNullConstraintException(nonNullableElements, ex);
    }

    static class BatchExceptionHandler {
        private final CdsEntity entity;

        public BatchExceptionHandler(CdsEntity entity) {
            this.entity = entity;
        }

        private int getFirstNonPositiveIndex(int[] rcs) {
            for (int pos = 0; pos < rcs.length; ++pos) {
                if (rcs[pos] >= 0) continue;
                return pos;
            }
            return rcs.length;
        }

        public CdsException uniqueConstraint(List<Map<String, Object>> entries, int updatedCount, BatchUpdateException ex) {
            int[] updateCounts = ex.getUpdateCounts();
            int badPos = this.getFirstNonPositiveIndex(updateCounts);
            Map<String, Object> entry = entries.get(badPos + updatedCount);
            return new UniqueConstraintException(this.entity, entry, CdsModelUtils.concreteKeyNames((CdsStructuredType)this.entity), (Exception)ex);
        }

        public CdsException notNullConstraint(List<Map<String, Object>> entries, int updatedCount, BatchUpdateException ex) {
            int[] updateCounts = ex.getUpdateCounts();
            int badPos = this.getFirstNonPositiveIndex(updateCounts);
            Map<String, Object> entryValues = entries.get(badPos + updatedCount);
            return ExceptionHandler.notNullConstraintException(this.entity, entryValues, ex);
        }
    }
}

