/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.qat;

import com.google.common.base.Strings;
import com.sap.cds.impl.builder.model.ElementRefImpl;
import com.sap.cds.impl.docstore.DocStoreUtils;
import com.sap.cds.impl.localized.LocaleUtils;
import com.sap.cds.impl.qat.QatElementNode;
import com.sap.cds.impl.qat.QatNode;
import com.sap.cds.impl.qat.QatSelectableNode;
import com.sap.cds.impl.qat.QatStructuredElementNode;
import com.sap.cds.jdbc.spi.SqlMapping;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnValidationException;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsStructuredType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public class Ref2QualifiedColumn
implements Function<CqnElementRef, String> {
    private final QatSelectableNode root;
    private final QatSelectableNode outer;
    private final String rootName;
    private final SqlMapping sqlMapping;
    private final LocaleUtils localeUtils;
    private String collateClause = null;

    public Ref2QualifiedColumn(Function<CdsStructuredType, SqlMapping> mapping, Deque<QatSelectableNode> outer, LocaleUtils localeUtils) {
        Iterator<QatSelectableNode> reverse = outer.descendingIterator();
        this.root = Ref2QualifiedColumn.qatRoot(reverse.next());
        this.rootName = this.root.rowType().getQualifiedName();
        this.outer = reverse.hasNext() ? reverse.next() : null;
        this.sqlMapping = mapping.apply(this.root.rowType());
        this.localeUtils = localeUtils;
    }

    public void startCollate(String collateClause) {
        if (Strings.emptyToNull((String)collateClause) != null) {
            this.collateClause = " " + collateClause;
        } else {
            this.stopCollate();
        }
    }

    public void stopCollate() {
        this.collateClause = null;
    }

    @Override
    public String apply(CqnElementRef ref) {
        List segments = ref.segments();
        if (ref.firstSegment().equals("$outer")) {
            return this.qualifiedColumnName(segments.subList(1, segments.size()), this.outer);
        }
        return this.qualifiedColumnName(segments, this.root);
    }

    private String qualifiedColumnName(List<? extends CqnReference.Segment> segments, QatNode node) {
        String columnName;
        boolean firstSegment = true;
        for (CqnReference.Segment segment : segments) {
            if (firstSegment && segment.id().equals(this.rootName)) continue;
            node = node.child(segment.id(), segment.filter());
            Ref2QualifiedColumn.assertNotNull(segments, node);
            firstSegment = false;
        }
        if (node instanceof QatElementNode) {
            columnName = this.columnName(node);
        } else {
            throw new CqnValidationException(node.name() + " does not refer to an element");
        }
        while ((node = node.parent()) != null && !(node instanceof QatSelectableNode)) {
        }
        Ref2QualifiedColumn.assertNotNull(segments, node);
        String tableAlias = ((QatSelectableNode)node).alias();
        return Ref2QualifiedColumn.column(tableAlias, columnName);
    }

    private static String column(String alias, String col) {
        return alias + "." + col;
    }

    private static QatSelectableNode qatRoot(QatNode root) {
        Optional<QatNode> next;
        while ((next = Ref2QualifiedColumn.childInSource(root)).isPresent()) {
            root = next.get();
        }
        return (QatSelectableNode)root;
    }

    private static Optional<QatNode> childInSource(QatNode root) {
        return root.children().stream().filter(QatNode::inSource).findFirst();
    }

    private String columnName(QatNode node) {
        QatElementNode elementNode = (QatElementNode)node;
        CdsElement cdsElement = elementNode.element();
        Object columnName = this.sqlMapping.columnName(cdsElement);
        if (node.parent() instanceof QatStructuredElementNode) {
            if (DocStoreUtils.targetsDocStore((CdsStructuredType)cdsElement.getDeclaringType())) {
                return columnName;
            }
            if (cdsElement.findAnnotation("cds.persistence.name").isEmpty()) {
                columnName = this.structuredColumnName(node);
            }
        }
        if (this.collateClause != null && this.localeUtils.requiresCollate(cdsElement)) {
            columnName = (String)columnName + this.collateClause;
        }
        return columnName;
    }

    private String structuredColumnName(QatNode node) {
        ArrayList<String> elementName = new ArrayList<String>();
        elementName.add(((QatElementNode)node).element().getName());
        QatNode parent = node.parent();
        while (parent instanceof QatStructuredElementNode) {
            QatStructuredElementNode structNode = (QatStructuredElementNode)parent;
            elementName.add(structNode.element().getName());
            parent = structNode.parent();
        }
        Collections.reverse(elementName);
        return this.sqlMapping.delimitedCasing(String.join((CharSequence)"_", elementName));
    }

    private static void assertNotNull(List<? extends CqnReference.Segment> segments, QatNode node) {
        if (node == null) {
            ElementRef ref = ElementRefImpl.elementRef(segments, null, null);
            throw new CqnValidationException("Unresolvable path expression: " + ref.toJson());
        }
    }
}

