/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.jdbc.hana;

import com.sap.cds.CdsDataStoreConnector;
import com.sap.cds.DataStoreConfiguration;
import com.sap.cds.jdbc.generic.GenericDbContext;
import com.sap.cds.jdbc.hana.HanaBinder;
import com.sap.cds.jdbc.hana.HanaExceptionAnalyzer;
import com.sap.cds.jdbc.hana.HanaPredicateMapper;
import com.sap.cds.jdbc.hana.HanaSessionVariableSetter;
import com.sap.cds.jdbc.hana.HanaStatementResolver;
import com.sap.cds.jdbc.hana.LocalizedViewSearchResolver;
import com.sap.cds.jdbc.hana.search.HanaSearchResolver;
import com.sap.cds.jdbc.spi.ExceptionAnalyzer;
import com.sap.cds.jdbc.spi.PredicateMapper;
import com.sap.cds.jdbc.spi.SearchResolver;
import com.sap.cds.jdbc.spi.SessionVariableSetter;
import com.sap.cds.jdbc.spi.StatementResolver;
import com.sap.cds.jdbc.spi.ValueBinder;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.reflect.CdsModel;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HanaDbContext
extends GenericDbContext {
    public static final String USE_HEX_PLAN = "hdb.USE_HEX_PLAN";
    public static final String NO_USE_HEX_PLAN = "hdb.NO_USE_HEX_PLAN";
    private static final Logger logger = LoggerFactory.getLogger(HanaDbContext.class);
    private final int majorVersion;
    private boolean optimizeForHexEngine;

    public HanaDbContext(DataStoreConfiguration dataStoreConfiguration, int majorVersion) {
        super(dataStoreConfiguration);
        this.majorVersion = majorVersion;
        this.optimizeForHexEngine = majorVersion >= 4 && "hex".equals(this.config.getProperty("cds.sql.hana.compatibilityMode"));
    }

    @Override
    public SearchResolver createSearchResolver(CdsModel model, Locale locale, CqnSelect select) {
        boolean useLocalizedViewSearchResolver = this.config.getProperty("cds.sql.search.use-localized-view", false);
        if (useLocalizedViewSearchResolver) {
            logger.debug("Switched to LocalizedViewSearchResolver due to provided configuration.");
            return new LocalizedViewSearchResolver(model, locale);
        }
        Map hints = select.hints();
        if (hints.containsKey(USE_HEX_PLAN)) {
            return HanaSearchResolver.forLegacyEngine(model, locale);
        }
        if (hints.containsKey(NO_USE_HEX_PLAN) || this.optimizeForHexEngine) {
            return HanaSearchResolver.forHexEngine(model, locale);
        }
        return HanaSearchResolver.forLegacyEngine(model, locale);
    }

    @Override
    public StatementResolver getStatementResolver() {
        return new HanaStatementResolver(this.config, this.majorVersion, this.optimizeForHexEngine);
    }

    @Override
    public PredicateMapper getPredicateMapper() {
        return new HanaPredicateMapper();
    }

    @Override
    public ExceptionAnalyzer getExceptionAnalyzer() {
        return new HanaExceptionAnalyzer();
    }

    @Override
    public CdsDataStoreConnector.Capabilities getCapabilities() {
        return CdsDataStoreConnector.Capabilities.ALL;
    }

    @Override
    public ValueBinder getBinder(TimeZone timeZone) {
        return new HanaBinder(timeZone);
    }

    @Override
    public SessionVariableSetter getSessionVariableSetter() {
        return new HanaSessionVariableSetter();
    }
}

