/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.jdbc.hana;

import com.sap.cds.CdsException;
import com.sap.cds.DataStoreConfiguration;
import com.sap.cds.impl.localized.LocaleUtils;
import com.sap.cds.impl.sql.SQLHelper;
import com.sap.cds.jdbc.spi.StatementResolver;
import com.sap.cds.ql.cqn.CqnLock;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSortSpecification;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HanaStatementResolver
implements StatementResolver {
    private static final Logger logger = LoggerFactory.getLogger(HanaStatementResolver.class);
    private static final Properties COLLATIONS = new Properties();
    private final boolean ignoreLocale;
    private final boolean hanaCloud;
    private final boolean optimizeForHexEngine;

    public HanaStatementResolver(DataStoreConfiguration dataStoreConfiguration, int majorVersion, boolean optimizeForHexEngine) {
        this.optimizeForHexEngine = optimizeForHexEngine;
        this.hanaCloud = majorVersion >= 4;
        this.ignoreLocale = dataStoreConfiguration.getProperty("cds.sql.hana.ignore-locale", false);
        if (this.hanaCloud) {
            HanaStatementResolver.loadCollations();
        }
    }

    private static void loadCollations() {
        try (InputStream in = HanaStatementResolver.class.getClassLoader().getResourceAsStream("hana/collations.properties");){
            COLLATIONS.load(in);
        }
        catch (Exception e) {
            throw new CdsException("Failed to load HANA collations");
        }
    }

    public Optional<String> collate(CqnSortSpecification o, Locale locale) {
        if (locale != null) {
            return HanaStatementResolver.collation("COLLATE ", locale);
        }
        return Optional.empty();
    }

    private static Optional<String> collation(String prefix, Locale locale) {
        String collationName = HanaStatementResolver.getCollationName(locale);
        if (collationName == null) {
            logger.warn("Missing collation name for locale \"{}\"", (Object)locale);
            return Optional.empty();
        }
        return Optional.of(prefix + collationName);
    }

    private static String getCollationName(Locale locale) {
        String collationName;
        String language = locale.getLanguage();
        if (("zh".equals(language) || "hr".equals(language)) && (collationName = COLLATIONS.getProperty(locale.toLanguageTag())) != null) {
            return collationName;
        }
        return COLLATIONS.getProperty(language);
    }

    public Optional<String> statementWideCollation(CqnSelect select, Locale locale) {
        if (this.ignoreLocale || locale == null) {
            return Optional.empty();
        }
        Map hints = select.hints();
        if ("off".equals(hints.get("collating"))) {
            return Optional.empty();
        }
        if (hints.containsKey("hdb.NO_USE_HEX_PLAN")) {
            return Optional.of(HanaStatementResolver.parametersLocale(locale));
        }
        if ((this.optimizeForHexEngine || hints.containsKey("hdb.USE_HEX_PLAN")) && this.hanaCloud) {
            return HanaStatementResolver.collation("WITH COLLATION ", locale);
        }
        return Optional.of(HanaStatementResolver.parametersLocale(locale));
    }

    public boolean supportsStatementWideCollation() {
        return true;
    }

    private static String parametersLocale(Locale locale) {
        return "with parameters('LOCALE' = " + SQLHelper.literal(LocaleUtils.getLocaleString((Locale)locale)) + ")";
    }

    public String upsert(String table, Stream<String> keyColumns, Stream<String> upsertColumns, Stream<String> upsertValues) {
        String columns = SQLHelper.commaSeparated(upsertColumns);
        String values = SQLHelper.commaSeparated(upsertValues);
        return Stream.of("UPSERT", table, columns, "VALUES", values, "WITH PRIMARY KEY").collect(Collectors.joining(" "));
    }

    public String lockMode(CqnLock.Mode mode) {
        return switch (mode) {
            case CqnLock.Mode.SHARED -> {
                if (this.hanaCloud) {
                    yield "FOR SHARE LOCK";
                }
            }
            default -> "FOR UPDATE";
        };
    }

    public Optional<String> timeoutClause(int timeoutSeconds) {
        if (timeoutSeconds > 0) {
            return Optional.of("WAIT " + timeoutSeconds);
        }
        return Optional.of("NOWAIT");
    }

    public Optional<String> hints(Map<String, Object> hints) {
        List<String> hanaHints = hints.keySet().stream().filter(h -> h.startsWith("hdb.")).map(h -> h.substring(4)).toList();
        if (hanaHints.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(hanaHints.stream().collect(Collectors.joining(", ", "WITH HINT(", ")")));
    }
}

