/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.jdbc.sqlite;

import com.sap.cds.jdbc.spi.SessionVariableSetter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import org.sqlite.Function;
import org.sqlite.SQLiteConnection;

public class SqliteSessionVariableSetter
implements SessionVariableSetter {
    public void set(Connection conn, Map<String, Object> contextVariables) throws SQLException {
        SQLiteConnection sqliteCon = conn.unwrap(SQLiteConnection.class);
        Function.create((Connection)sqliteCon, (String)"session_context", (Function)new SessionContextFunction(contextVariables));
    }

    private static class SessionContextFunction
    extends Function {
        private Map<String, Object> contextVariables;

        public SessionContextFunction(Map<String, Object> contextVariables) {
            this.contextVariables = contextVariables;
        }

        protected void xFunc() throws SQLException {
            String sqliteKey;
            String key = switch (sqliteKey = this.value_text(0)) {
                case "$user.id" -> "APPLICATIONUSER";
                case "$user.locale" -> "LOCALE";
                case "$valid.from", "$at.from" -> "VALID-FROM";
                case "$valid.to", "$at.to" -> "VALID-TO";
                default -> null;
            };
            Object val = this.contextVariables.get(key);
            if (val != null) {
                this.result(val.toString());
            } else {
                this.result();
            }
        }
    }
}

