/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.ql.impl;

import com.sap.cds.DataStoreConfiguration;
import com.sap.cds.SessionContext;
import com.sap.cds.impl.Context;
import com.sap.cds.impl.DraftUtils;
import com.sap.cds.impl.builder.model.ExistsSubquery;
import com.sap.cds.jdbc.spi.SearchResolver;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.cqn.CqnAnalyzer;
import com.sap.cds.ql.cqn.CqnDelete;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnExistsSubquery;
import com.sap.cds.ql.cqn.CqnExpand;
import com.sap.cds.ql.cqn.CqnInsert;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnSelectListValue;
import com.sap.cds.ql.cqn.CqnSortSpecification;
import com.sap.cds.ql.cqn.CqnSource;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnUpdate;
import com.sap.cds.ql.cqn.CqnUpsert;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.cqn.CqnXsert;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.ql.impl.MatchPredicateNormalizer;
import com.sap.cds.ql.impl.SelectBuilder;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.CqnCalculatedElementsSubstitutor;
import com.sap.cds.util.CqnStatementUtils;
import com.sap.cds.util.NestedStructsResolver;
import com.sap.cds.util.OnConditionAnalyzer;
import com.sap.cds.util.PathExpressionResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CqnNormalizer {
    private final CdsModel cdsModel;
    private final DataStoreConfiguration config;
    private final CqnAnalyzer analyzer;
    private final Context context;
    private SessionContext sessionContext;
    private SearchResolver searchResolver;

    public CqnNormalizer(Context context) {
        this.context = context;
        this.cdsModel = context.getCdsModel();
        this.sessionContext = context.getSessionContext();
        this.analyzer = CqnAnalyzer.create((CdsModel)this.cdsModel);
        this.config = context.getDataStoreConfiguration();
    }

    private SearchResolver getSearchResolver(CqnSelect select) {
        if (null == this.searchResolver) {
            this.searchResolver = this.context.getSearchResolver(select);
        }
        return this.searchResolver;
    }

    public CqnSelect normalize(CqnSelect select) {
        Select copy = this.normalizeSubqueries(select);
        CdsStructuredType target = CqnStatementUtils.targetType((CdsModel)this.cdsModel, copy);
        boolean includeAssocs = this.includeManagedAssocs((CqnSelect)copy);
        CqnStatementUtils.resolveStar(copy, (CdsStructuredType)target, (boolean)includeAssocs);
        NestedStructsResolver.resolveNestedStructs(copy, (CdsStructuredType)target, (boolean)includeAssocs);
        CqnStatementUtils.resolveKeyPlaceholder((CdsStructuredType)target, copy);
        CqnStatementUtils.resolveStructureComparison((CdsStructuredType)target, copy);
        copy = CqnStatementUtils.resolveExpands(copy, (CdsStructuredType)target, (boolean)includeAssocs);
        CqnStatementUtils.unfoldInline((Select)copy, (CdsStructuredType)target);
        this.substituteAliasesInOderingSpec(copy);
        CqnStatementUtils.removeVirtualElements((Select)copy, (CdsStructuredType)target);
        copy = (Select)this.getSearchResolver(select).resolve((CqnSelect)copy);
        copy = this.resolveMatchPredicates(target, copy);
        copy = (Select)DraftUtils.resolveConstantElements(this.cdsModel, target, (CqnSelect)copy);
        CqnStatementUtils.simplify((CdsStructuredType)target, (Select)copy);
        return copy;
    }

    private void substituteAliasesInOderingSpec(Select<?> source) {
        List sortSpecifications = source.orderBy();
        if (!sortSpecifications.isEmpty()) {
            source.orderBy(sortSpecifications.stream().map(spec -> {
                if (spec.value().isRef()) {
                    return source.items().stream().flatMap(CqnSelectListItem::ofValue).filter(v -> v.alias().isPresent()).filter(v -> spec.value().asRef().path().equals(v.displayName())).findFirst().map(v -> CQL.sort((CqnValue)v.value(), (CqnSortSpecification.Order)spec.order())).orElse((CqnSortSpecification)spec);
                }
                return spec;
            }).toList());
        }
    }

    private boolean includeManagedAssocs(CqnSelect select) {
        return select.from().isRef() && this.config.getProperty("cds.model.universalCsn", false) && "columns".equals(this.config.getProperty("cds.sql.select.star"));
    }

    public CqnSelect resolveForwardMappedAssocs(CqnSelect select) {
        CdsStructuredType target = CqnStatementUtils.targetType((CdsModel)this.cdsModel, (CqnSelect)select);
        return this.resolveForwardMappedAssocs(select, target);
    }

    private CqnSelect resolveForwardMappedAssocs(CqnSelect select, final CdsStructuredType target) {
        return SelectBuilder.copy((CqnSelect)select, (Modifier)new Modifier(){

            public List<CqnSelectListItem> items(List<CqnSelectListItem> items) {
                List<CqnSelectListItem> resolved = CqnNormalizer.this.resolveForwardMappedAssocs(target, items);
                return super.items(resolved);
            }

            public CqnSelectListItem expand(CqnExpand expand) {
                if (!expand.ref().lastSegment().equals("*")) {
                    CdsEntity expTarget = CdsModelUtils.entity((CdsEntity)((CdsEntity)target), (List)expand.ref().segments());
                    List<CqnSelectListItem> resolved = CqnNormalizer.this.resolveForwardMappedAssocs((CdsStructuredType)expTarget, expand.items());
                    return CQL.copy((CqnExpand)expand).items(resolved);
                }
                return expand;
            }
        }, (boolean)false);
    }

    private List<CqnSelectListItem> resolveForwardMappedAssocs(CdsStructuredType target, List<CqnSelectListItem> items) {
        ArrayList<CqnSelectListItem> slis = new ArrayList<CqnSelectListItem>();
        for (CqnSelectListItem item : items) {
            CdsElement element;
            if (item.isRef() && (element = CdsModelUtils.element((CdsStructuredType)target, (CqnElementRef)item.asRef())).getType().isAssociation()) {
                slis.addAll(this.resolveForwardMappedAssoc(target, item.asValue(), element));
                continue;
            }
            slis.add(item);
        }
        return slis;
    }

    private List<CqnSelectListItem> resolveForwardMappedAssoc(CdsStructuredType target, CqnSelectListValue refValue, CdsElement element) {
        ArrayList<CqnSelectListItem> slis = new ArrayList<CqnSelectListItem>();
        CqnElementRef ref = refValue.value().asRef();
        if (!CqnStatementUtils.isToOnePath((CdsStructuredType)target, (List)ref.segments()) || CdsModelUtils.isReverseAssociation((CdsElement)element)) {
            throw new UnsupportedOperationException("Association " + element.getQualifiedName() + " is not supported on the select list. Only forward-mapped to-one associations are supported on the select list");
        }
        OnConditionAnalyzer onCondAnalyzer = new OnConditionAnalyzer(element, false);
        onCondAnalyzer.getFkMapping().forEach((fk, r) -> {
            if (!fk.contains(".") && r.isRef() && r.asRef().firstSegment().equals(ref.lastSegment())) {
                ElementRef elementRef = CQL.to(ref.segments().subList(0, ref.segments().size() - 1)).get(fk);
                slis.add((CqnSelectListItem)elementRef.as(refValue.displayName() + "." + r.asRef().displayName()));
            }
        });
        return slis;
    }

    private <S extends CqnStatement> S resolveMatchPredicates(CdsStructuredType target, S stmt) {
        return new MatchPredicateNormalizer(this.cdsModel, target).normalize(stmt);
    }

    private Select<?> normalizeSubqueries(CqnSelect select) {
        CqnSource source = select.from();
        if (!source.isSelect()) {
            return SelectBuilder.copy((CqnSelect)select);
        }
        select.search().ifPresent(s -> this.getSearchResolver(select).pushDownSearchToSubquery(select, select.from().asSelect()));
        CqnSelect inner = this.normalize(source.asSelect());
        SelectBuilder outerSelect = (SelectBuilder)Select.from((CqnSelect)inner);
        this.moveAllQueryPartsFromOldSelectToNewOuterSelect(select, outerSelect);
        return outerSelect;
    }

    private void moveAllQueryPartsFromOldSelectToNewOuterSelect(CqnSelect select, SelectBuilder<?> outer) {
        if (select.isDistinct()) {
            outer.distinct();
        }
        if (select.hasInlineCount()) {
            outer.inlineCount();
        }
        outer.columns(select.items());
        select.where().ifPresent(arg_0 -> outer.where(arg_0));
        select.search().ifPresent(s -> {
            Predicate searchExpression = (Predicate)s;
            Collection searchableElements = outer.searchableElements();
            outer.search(e -> searchExpression, (Iterable)searchableElements);
        });
        select.having().ifPresent(arg_0 -> outer.having(arg_0));
        outer.groupBy(select.groupBy());
        outer.orderBy(select.orderBy());
        outer.limit(select.top(), select.skip());
        outer.excluding((Collection)select.excluding());
        select.getLock().ifPresent(l -> outer.lock(((Integer)l.timeout().get()).intValue()));
    }

    public CqnInsert normalize(CqnInsert insert) {
        insert = (CqnInsert)PathExpressionResolver.resolvePath((CdsModel)this.cdsModel, (CqnXsert)insert, (SessionContext)this.sessionContext);
        return insert;
    }

    public CqnUpsert normalize(CqnUpsert upsert) {
        upsert = (CqnUpsert)PathExpressionResolver.resolvePath((CdsModel)this.cdsModel, (CqnXsert)upsert, (SessionContext)this.sessionContext);
        return upsert;
    }

    public CqnUpdate normalize(CqnUpdate update) {
        update = PathExpressionResolver.resolvePath((CdsModel)this.cdsModel, (CqnUpdate)update);
        CdsEntity target = CdsModelUtils.entity((CdsModel)this.cdsModel, (CqnStructuredTypeRef)update.ref());
        update = (CqnUpdate)CQL.copy((CqnStatement)update, (Modifier)new CqnCalculatedElementsSubstitutor((CdsStructuredType)target));
        return this.norm(update);
    }

    public CqnDelete normalize(CqnDelete delete) {
        delete = PathExpressionResolver.resolvePath((CdsModel)this.cdsModel, (CqnDelete)delete);
        CdsEntity target = CdsModelUtils.entity((CdsModel)this.cdsModel, (CqnStructuredTypeRef)delete.ref());
        delete = (CqnDelete)CQL.copy((CqnStatement)delete, (Modifier)new CqnCalculatedElementsSubstitutor((CdsStructuredType)target));
        return this.norm(delete);
    }

    public CqnExistsSubquery normalize(CqnExistsSubquery existsSubquery) {
        CqnSelect query = existsSubquery.subquery();
        CdsStructuredType target = CqnStatementUtils.targetType((CdsModel)this.cdsModel, (CqnSelect)query);
        query = this.getSearchResolver(query).resolve(query);
        query = this.resolveMatchPredicates(target, query);
        query = (CqnSelect)CqnStatementUtils.resolveKeyPlaceholder((CdsStructuredType)target, (CqnStatement)query);
        CqnStatementUtils.simplify((CdsStructuredType)target, (Select)((Select)query));
        return new ExistsSubquery(query);
    }

    private <S extends CqnStatement> S norm(S stmt) {
        CdsEntity target = this.analyzer.analyze(stmt.ref()).targetEntity();
        stmt = CqnStatementUtils.resolveKeyPlaceholder((CdsStructuredType)target, stmt);
        stmt = CqnStatementUtils.resolveStructureComparison((CdsStructuredType)target, stmt);
        stmt = this.resolveMatchPredicates((CdsStructuredType)target, stmt);
        return stmt;
    }
}

