/*******************************************************************
 * © 2019 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.impl;

import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

import com.sap.cds.CdsDataStore;
import com.sap.cds.CdsDataStoreConnector.Capabilities;
import com.sap.cds.ResultBuilder;
import com.sap.cds.SessionContext;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.reflect.CdsEntity;

public interface ConnectedClient {

	PreparedCqnStatement prepare(CqnStatement statement);

	ResultBuilder executeQuery(PreparedCqnStatement preparedStmt, Map<String, Object> cqnParameterValues,
			CdsDataStore dataStore, boolean isTransactionRequired);

	int[] executeUpdate(PreparedCqnStatement preparedStmt, List<Map<String, Object>> values);

	void setSessionContext(SessionContext session);

	/**
	 * If the current thread is associated with an active transaction it is set in
	 * rollback only mode
	 */
	void setRollbackOnly();

	Capabilities capabilities();

	void deleteAll(Stream<CdsEntity> entities);

}
