/*******************************************************************
 * © 2019 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.impl;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

import com.google.common.collect.ForwardingList;
import com.google.common.collect.Lists;
import com.sap.cds.CdsDataStore;
import com.sap.cds.JSONizable;
import com.sap.cds.Row;
import com.sap.cds.impl.parser.token.Jsonizer;
import com.sap.cds.ql.cqn.CqnSelect;

public class LazyResultImpl extends ForwardingList<Row> implements Lazy, JSONizable {

	private final AtomicBoolean loaded = new AtomicBoolean();
	private final CdsDataStore dataStore;
	private final CqnSelect query;
	private List<Row> rows;

	public LazyResultImpl(CdsDataStore dataStore, CqnSelect query) {
		this.dataStore = dataStore;
		this.query = query;
	}

	@Override
	protected List<Row> delegate() {
		load();
		return rows;
	}

	@Override
	public void load() {
		if (loaded.compareAndSet(false, true)) {
			rows = dataStore.execute(query).list();
		}
	}

	@Override
	public boolean isLoaded() {
		return loaded.get();
	}

	@Override
	public Object loadData() {
		return Lists.newArrayList(delegate());
	}

	@Override
	public String toJson() {
		return isLoaded() ? Jsonizer.json(rows) : null;
	}

	@Override
	public String toString() {
		return toJson();
	}

}
