/*******************************************************************
 * © 2019 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.impl.qat;

import java.util.Optional;

import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.reflect.CdsEntity;

public abstract class QatEntityNode extends QatSelectableNode {

	private final CqnPredicate filter;
	private final boolean inSource;

	public QatEntityNode(QatNode parent, CdsEntity entity, Optional<CqnPredicate> filter, boolean inSource) {
		super(parent, entity);
		this.filter = filter.orElse(null);
		this.inSource = inSource;
	}

	@Override
	public CdsEntity rowType() {
		return (CdsEntity) super.rowType();
	}

	public boolean inSource() {
		return inSource;
	}

	public Optional<CqnPredicate> filter() {
		return Optional.ofNullable(filter);
	}

	@Override
	public String toString() {
		StringBuilder txt = new StringBuilder();
		if (alias() != null) {
			txt.append(alias());
			txt.append(" ");
		}
		txt.append(name());
		filter().ifPresent(f -> txt.append(" ").append(f.toJson()));

		return txt.toString();
	}
}
