package com.sap.cds.jdbc.generic;

import java.sql.SQLException;
import java.sql.SQLTimeoutException;

import com.sap.cds.jdbc.spi.ExceptionAnalyzer;

public class GenericExceptionAnalyzer implements ExceptionAnalyzer {
    public static final String NOT_NULL_CONSTRAINT_ERROR_CODE = "23502";
    public static final String UNIQUE_CONSTRAINT_ERROR_CODE = "23505";

    public boolean isUniqueConstraint(SQLException ex) {
        return UNIQUE_CONSTRAINT_ERROR_CODE.equals(ex.getSQLState());
    }

    public boolean isNotNullConstraint(SQLException ex) {
        return NOT_NULL_CONSTRAINT_ERROR_CODE.equals(ex.getSQLState());
    }

    public boolean isLockTimeout(SQLException ex) {
        return ex instanceof SQLTimeoutException;
    }
}
