/************************************************************************
 * © 2020-2023 SAP SE or an SAP affiliate company. All rights reserved. *
 ************************************************************************/
package com.sap.cds.jdbc.generic;

import com.sap.cds.jdbc.spi.PredicateMapper;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.impl.ExpressionVisitor;

public class GenericPredicateMapper implements PredicateMapper {

	@Override
	public CqnPredicate apply(CqnPredicate pred) {
		return ExpressionVisitor.copy(pred, new GenericPredicateModifier());
	}
}
