/************************************************************************
 * © 2020-2022 SAP SE or an SAP affiliate company. All rights reserved. *
 ************************************************************************/
package com.sap.cds.jdbc.h2;

import java.util.Locale;

import com.sap.cds.CdsDataStoreConnector.Capabilities;
import com.sap.cds.DataStoreConfiguration;
import com.sap.cds.jdbc.generic.GenericDbContext;
import com.sap.cds.jdbc.generic.LocaleNameTableNameResolver;
import com.sap.cds.jdbc.spi.ExceptionAnalyzer;
import com.sap.cds.jdbc.spi.FunctionMapper;
import com.sap.cds.jdbc.spi.SessionVariableSetter;
import com.sap.cds.jdbc.spi.StatementResolver;
import com.sap.cds.jdbc.spi.TableNameResolver;

public final class H2DbContext extends GenericDbContext {

	public H2DbContext(DataStoreConfiguration dataStoreConfiguration) {
		super(dataStoreConfiguration);
	}

	@Override
	public FunctionMapper getFunctionMapper() {
		return new H2FunctionMapper();
	}

	@Override
	public StatementResolver getStatementResolver() {
		return new H2StatementResolver();
	}

	@Override
	public ExceptionAnalyzer getExceptionAnalyzer() {
		return new H2ExceptionAnalyzer();
	}

	@Override
	public Capabilities getCapabilities() {
		return new Capabilities() {
		};
	}

	@Override
	public SessionVariableSetter getSessionVariableSetter() {
		return new H2SessionVariableSetter();
	}

	@Override
	public TableNameResolver createTableNameResolver(Locale locale) {
		if (config.useLocaleSpecificView()) {
			return new LocaleNameTableNameResolver(this::getSqlMapping, config, locale);
		}

		return super.createTableNameResolver(locale);

	}
}
