/************************************************************************
 * © 2021-2022 SAP SE or an SAP affiliate company. All rights reserved. *
 ************************************************************************/
package com.sap.cds.jdbc.h2;

import java.util.List;
import java.util.Locale;

import com.sap.cds.impl.parser.token.CqnPlainImpl;
import com.sap.cds.jdbc.generic.GenericFunctionMapper;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.cqn.CqnPlain;
import com.sap.cds.ql.cqn.CqnValue;

public class H2FunctionMapper extends GenericFunctionMapper {
	
	protected static final CqnPlain ILIKE = CqnPlainImpl.plain("ILIKE");

	@Override
	public String toSql(String cqnFunc, List<String> args) {
		String func = cqnFunc.toLowerCase(Locale.US);
		switch (func) {
		case "current_time":
			return "cast(current_time as time)";
		default:
			return super.toSql(cqnFunc, args);
		}
	}
	
	@Override
	public Predicate like(CqnValue value, CqnValue pattern, String esc, boolean caseInsensitive) {
		return ilike(value, pattern, esc, caseInsensitive);
	}

}
