/*******************************************************************
 * © 2023 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.jdbc.hana;

import com.sap.cds.jdbc.generic.GenericPredicateMapper;
import com.sap.cds.jdbc.generic.GenericPredicateModifier;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnComparisonPredicate.Operator;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.ql.impl.ExpressionVisitor;
import com.sap.cds.util.CqnStatementUtils;

public class HanaPredicateMapper extends GenericPredicateMapper {

	@Override
	public CqnPredicate apply(CqnPredicate pred) {
		Modifier m = new GenericPredicateModifier() {

			@Override
			public CqnPredicate comparison(Value<?> lhs, Operator op, Value<?> rhs) {
				switch (op) {
					case GT:
					case GE:
					case LT:
					case LE:
						return CqnStatementUtils.unfold(CQL.comparison(lhs, op, rhs));
					default:
						break;
				}
				return super.comparison(lhs, op, rhs);
			}

		};

		return ExpressionVisitor.copy(pred, m);
	}
}
