/*******************************************************************
 * © 2022 SAP SE or an SAP affiliate company. All rights reserved. *
 ******************************************************************/
package com.sap.cds.jdbc.hana;

import static com.sap.cds.util.CdsTypeUtils.sqlTimestamp;

import java.sql.Connection;
import java.sql.SQLException;
import java.time.Instant;
import java.util.Map;
import java.util.Map.Entry;

import com.sap.cds.jdbc.spi.SessionVariableSetter;

public class HanaSessionVariableSetter implements SessionVariableSetter {

	@Override
	public void set(Connection conn, Map<String, Object> contextVariables) throws SQLException {
		for (Entry<String, Object> setting : contextVariables.entrySet()) {
			set(conn, setting.getKey(), setting.getValue());
		}

	}

	private void set(Connection conn, String key, Object value) throws SQLException {
		String val = switch (key) {
			case VALID_FROM, VALID_TO -> sqlTimestamp((Instant) value, 7);
			default -> value != null ? value.toString() : null;
		};
		conn.setClientInfo(key, val);
	}

}
