package com.sap.cds.jdbc.hana;

import java.util.Collection;
import java.util.Locale;

import com.sap.cds.jdbc.generic.AbstractSearchResolver;
import com.sap.cds.jdbc.spi.SearchResolver;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;

/**
 * A {@link SearchResolver} implementation that renders LIKE expressions
 * directly on the searchable elements of the localized views generated by the
 * CDS compiler.
 */
public class LocalizedViewSearchResolver extends AbstractSearchResolver {

	public LocalizedViewSearchResolver(CdsModel cdsModel, Locale locale) {
		super(cdsModel, locale);
	}

	@Override
	protected void resolve(CqnSelect select, CqnPredicate search, CdsStructuredType targetType,
			Collection<CqnElementRef> searchableRefs) {

			resolveUsingLocalizedViewWithLike(select, search, targetType, searchableRefs, false);
	}
}
